"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const docdb_generated_1 = require("./docdb.generated");
/**
 * A new cluster or instance parameter group
 */
class ClusterParameterGroupBase extends core_1.Resource {
    /**
     * Imports a parameter group
     */
    static fromParameterGroupName(scope, id, parameterGroupName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.parameterGroupName = parameterGroupName;
            }
        }
        return new Import(scope, id);
    }
}
/**
 * A cluster parameter group
 *
 * @resource AWS::DocDB::DBClusterParameterGroup
 */
class ClusterParameterGroup extends ClusterParameterGroupBase {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new docdb_generated_1.CfnDBClusterParameterGroup(this, 'Resource', {
            name: props.dbClusterParameterGroupName,
            description: props.description || `Cluster parameter group for ${props.family}`,
            family: props.family,
            parameters: props.parameters,
        });
        this.parameterGroupName = resource.ref;
    }
}
exports.ClusterParameterGroup = ClusterParameterGroup;
//# sourceMappingURL=data:application/json;base64,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