"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_secretsmanager_1 = require("../../aws-secretsmanager"); // Automatically re-written from '@aws-cdk/aws-secretsmanager'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 *
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends aws_secretsmanager_1.Secret {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            secretName: props.secretName,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            encryptionKey: props.encryptionKey,
            // The CloudFormation resource provider for AWS::DocDB::DBCluster currently limits the DocDB master password to
            // 41 characters when pulling the password from secrets manager using a CloudFormation reference. This does not
            // line up with the CloudFormation resource specification which states a maximum of 100 characters:
            //
            // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-masteruserpassword
            //
            // When attempting to exceed 41 characters, a deployment fails with the message:
            // Length of value for property {/MasterUserPassword} is greater than maximum allowed length {41}
            generateSecretString: {
                passwordLength: 41,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: (_a = props.masterSecret) === null || _a === void 0 ? void 0 : _a.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters: '"@/',
            },
        });
    }
}
exports.DatabaseSecret = DatabaseSecret;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YWJhc2Utc2VjcmV0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZGF0YWJhc2Utc2VjcmV0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQ0EsaUVBQTJELENBQUMsOERBQThEO0FBQzFILHFDQUE0QyxDQUFDLGdEQUFnRDtBQTRCN0Y7Ozs7O0dBS0c7QUFDSCxNQUFhLGNBQWUsU0FBUSwyQkFBTTtJQUN0QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBCOztRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNiLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixXQUFXLEVBQUUsbUNBQW1DLFVBQUcsQ0FBQyxVQUFVLEVBQUU7WUFDaEUsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1lBQ2xDLCtHQUErRztZQUMvRywrR0FBK0c7WUFDL0csbUdBQW1HO1lBQ25HLEVBQUU7WUFDRiwwSUFBMEk7WUFDMUksRUFBRTtZQUNGLGdGQUFnRjtZQUNoRixpR0FBaUc7WUFDakcsb0JBQW9CLEVBQUU7Z0JBQ2xCLGNBQWMsRUFBRSxFQUFFO2dCQUNsQixvQkFBb0IsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDO29CQUNqQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7b0JBQ3hCLFNBQVMsUUFBRSxLQUFLLENBQUMsWUFBWSwwQ0FBRSxTQUFTO2lCQUMzQyxDQUFDO2dCQUNGLGlCQUFpQixFQUFFLFVBQVU7Z0JBQzdCLGlCQUFpQixFQUFFLEtBQUs7YUFDM0I7U0FDSixDQUFDLENBQUM7SUFDUCxDQUFDO0NBQ0o7QUF6QkQsd0NBeUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSUtleSB9IGZyb20gXCIuLi8uLi9hd3Mta21zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mta21zJ1xuaW1wb3J0IHsgSVNlY3JldCwgU2VjcmV0IH0gZnJvbSBcIi4uLy4uL2F3cy1zZWNyZXRzbWFuYWdlclwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXNlY3JldHNtYW5hZ2VyJ1xuaW1wb3J0IHsgQXdzLCBDb25zdHJ1Y3QgfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbi8qKlxuICogQ29uc3RydWN0aW9uIHByb3BlcnRpZXMgZm9yIGEgRGF0YWJhc2VTZWNyZXQuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRGF0YWJhc2VTZWNyZXRQcm9wcyB7XG4gICAgLyoqXG4gICAgICogVGhlIHVzZXJuYW1lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHVzZXJuYW1lOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIEtNUyBrZXkgdG8gdXNlIHRvIGVuY3J5cHQgdGhlIHNlY3JldC5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IGRlZmF1bHQgbWFzdGVyIGtleVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVuY3J5cHRpb25LZXk/OiBJS2V5O1xuICAgIC8qKlxuICAgICAqIFRoZSBwaHlzaWNhbCBuYW1lIG9mIHRoZSBzZWNyZXRcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IFNlY3JldHNtYW5hZ2VyIHdpbGwgZ2VuZXJhdGUgYSBwaHlzaWNhbCBuYW1lIGZvciB0aGUgc2VjcmV0XG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VjcmV0TmFtZT86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBUaGUgbWFzdGVyIHNlY3JldCB3aGljaCB3aWxsIGJlIHVzZWQgdG8gcm90YXRlIHRoaXMgc2VjcmV0LlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBubyBtYXN0ZXIgc2VjcmV0IGluZm9ybWF0aW9uIHdpbGwgYmUgaW5jbHVkZWRcbiAgICAgKi9cbiAgICByZWFkb25seSBtYXN0ZXJTZWNyZXQ/OiBJU2VjcmV0O1xufVxuLyoqXG4gKlxuICogQSBkYXRhYmFzZSBzZWNyZXQuXG4gKlxuICogQHJlc291cmNlIEFXUzo6U2VjcmV0c01hbmFnZXI6OlNlY3JldFxuICovXG5leHBvcnQgY2xhc3MgRGF0YWJhc2VTZWNyZXQgZXh0ZW5kcyBTZWNyZXQge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBEYXRhYmFzZVNlY3JldFByb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgICAgICAgc2VjcmV0TmFtZTogcHJvcHMuc2VjcmV0TmFtZSxcbiAgICAgICAgICAgIGRlc2NyaXB0aW9uOiBgR2VuZXJhdGVkIGJ5IHRoZSBDREsgZm9yIHN0YWNrOiAke0F3cy5TVEFDS19OQU1FfWAsXG4gICAgICAgICAgICBlbmNyeXB0aW9uS2V5OiBwcm9wcy5lbmNyeXB0aW9uS2V5LFxuICAgICAgICAgICAgLy8gVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHByb3ZpZGVyIGZvciBBV1M6OkRvY0RCOjpEQkNsdXN0ZXIgY3VycmVudGx5IGxpbWl0cyB0aGUgRG9jREIgbWFzdGVyIHBhc3N3b3JkIHRvXG4gICAgICAgICAgICAvLyA0MSBjaGFyYWN0ZXJzIHdoZW4gcHVsbGluZyB0aGUgcGFzc3dvcmQgZnJvbSBzZWNyZXRzIG1hbmFnZXIgdXNpbmcgYSBDbG91ZEZvcm1hdGlvbiByZWZlcmVuY2UuIFRoaXMgZG9lcyBub3RcbiAgICAgICAgICAgIC8vIGxpbmUgdXAgd2l0aCB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2Ugc3BlY2lmaWNhdGlvbiB3aGljaCBzdGF0ZXMgYSBtYXhpbXVtIG9mIDEwMCBjaGFyYWN0ZXJzOlxuICAgICAgICAgICAgLy9cbiAgICAgICAgICAgIC8vIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kb2NkYi1kYmNsdXN0ZXIuaHRtbCNjZm4tZG9jZGItZGJjbHVzdGVyLW1hc3RlcnVzZXJwYXNzd29yZFxuICAgICAgICAgICAgLy9cbiAgICAgICAgICAgIC8vIFdoZW4gYXR0ZW1wdGluZyB0byBleGNlZWQgNDEgY2hhcmFjdGVycywgYSBkZXBsb3ltZW50IGZhaWxzIHdpdGggdGhlIG1lc3NhZ2U6XG4gICAgICAgICAgICAvLyBMZW5ndGggb2YgdmFsdWUgZm9yIHByb3BlcnR5IHsvTWFzdGVyVXNlclBhc3N3b3JkfSBpcyBncmVhdGVyIHRoYW4gbWF4aW11bSBhbGxvd2VkIGxlbmd0aCB7NDF9XG4gICAgICAgICAgICBnZW5lcmF0ZVNlY3JldFN0cmluZzoge1xuICAgICAgICAgICAgICAgIHBhc3N3b3JkTGVuZ3RoOiA0MSxcbiAgICAgICAgICAgICAgICBzZWNyZXRTdHJpbmdUZW1wbGF0ZTogSlNPTi5zdHJpbmdpZnkoe1xuICAgICAgICAgICAgICAgICAgICB1c2VybmFtZTogcHJvcHMudXNlcm5hbWUsXG4gICAgICAgICAgICAgICAgICAgIG1hc3RlcmFybjogcHJvcHMubWFzdGVyU2VjcmV0Py5zZWNyZXRBcm4sXG4gICAgICAgICAgICAgICAgfSksXG4gICAgICAgICAgICAgICAgZ2VuZXJhdGVTdHJpbmdLZXk6ICdwYXNzd29yZCcsXG4gICAgICAgICAgICAgICAgZXhjbHVkZUNoYXJhY3RlcnM6ICdcIkAvJyxcbiAgICAgICAgICAgIH0sXG4gICAgICAgIH0pO1xuICAgIH1cbn1cbiJdfQ==