"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cognito_generated_1 = require("../cognito.generated");
const base_1 = require("./base");
/**
 * Represents a identity provider that integrates with 'Login with Amazon'
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderAmazon extends base_1.UserPoolIdentityProviderBase {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        const scopes = (_a = props.scopes) !== null && _a !== void 0 ? _a : ['profile'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: 'LoginWithAmazon',
            providerType: 'LoginWithAmazon',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(' '),
            },
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
}
exports.UserPoolIdentityProviderAmazon = UserPoolIdentityProviderAmazon;
//# sourceMappingURL=data:application/json;base64,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