"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * User pool third-party identity providers
 */
class UserPoolIdentityProvider {
    /**
     * Import an existing UserPoolIdentityProvider
     */
    static fromProviderName(scope, id, providerName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.providerName = providerName;
            }
        }
        return new Import(scope, id);
    }
    constructor() { }
}
exports.UserPoolIdentityProvider = UserPoolIdentityProvider;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlci1wb29sLWlkcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInVzZXItcG9vbC1pZHAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxxQ0FBNEQsQ0FBQyxnREFBZ0Q7QUFXN0c7O0dBRUc7QUFDSCxNQUFhLHdCQUF3QjtJQUNqQzs7T0FFRztJQUNJLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxZQUFvQjtRQUM3RSxNQUFNLE1BQU8sU0FBUSxlQUFRO1lBQTdCOztnQkFDb0IsaUJBQVksR0FBVyxZQUFZLENBQUM7WUFDeEQsQ0FBQztTQUFBO1FBQ0QsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7SUFDakMsQ0FBQztJQUNELGdCQUF3QixDQUFDO0NBQzVCO0FBWEQsNERBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QsIElSZXNvdXJjZSwgUmVzb3VyY2UgfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbi8qKlxuICogUmVwcmVzZW50cyBhIFVzZXJQb29sSWRlbnRpdHlQcm92aWRlclxuICovXG5leHBvcnQgaW50ZXJmYWNlIElVc2VyUG9vbElkZW50aXR5UHJvdmlkZXIgZXh0ZW5kcyBJUmVzb3VyY2Uge1xuICAgIC8qKlxuICAgICAqIFRoZSBwcmltYXJ5IGlkZW50aWZpZXIgb2YgdGhpcyBpZGVudGl0eSBwcm92aWRlclxuICAgICAqIEBhdHRyaWJ1dGVcbiAgICAgKi9cbiAgICByZWFkb25seSBwcm92aWRlck5hbWU6IHN0cmluZztcbn1cbi8qKlxuICogVXNlciBwb29sIHRoaXJkLXBhcnR5IGlkZW50aXR5IHByb3ZpZGVyc1xuICovXG5leHBvcnQgY2xhc3MgVXNlclBvb2xJZGVudGl0eVByb3ZpZGVyIHtcbiAgICAvKipcbiAgICAgKiBJbXBvcnQgYW4gZXhpc3RpbmcgVXNlclBvb2xJZGVudGl0eVByb3ZpZGVyXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBmcm9tUHJvdmlkZXJOYW1lKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3ZpZGVyTmFtZTogc3RyaW5nKTogSVVzZXJQb29sSWRlbnRpdHlQcm92aWRlciB7XG4gICAgICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSVVzZXJQb29sSWRlbnRpdHlQcm92aWRlciB7XG4gICAgICAgICAgICBwdWJsaWMgcmVhZG9ubHkgcHJvdmlkZXJOYW1lOiBzdHJpbmcgPSBwcm92aWRlck5hbWU7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgICB9XG4gICAgcHJpdmF0ZSBjb25zdHJ1Y3RvcigpIHsgfVxufVxuIl19