"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * The String custom attribute type.
 */
class StringAttribute {
    constructor(props = {}) {
        if (props.minLen && !core_1.Token.isUnresolved(props.minLen) && props.minLen < 0) {
            throw new Error(`minLen cannot be less than 0 (value: ${props.minLen}).`);
        }
        if (props.maxLen && !core_1.Token.isUnresolved(props.maxLen) && props.maxLen > 2048) {
            throw new Error(`maxLen cannot be greater than 2048 (value: ${props.maxLen}).`);
        }
        this.minLen = props === null || props === void 0 ? void 0 : props.minLen;
        this.maxLen = props === null || props === void 0 ? void 0 : props.maxLen;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        let stringConstraints;
        if (this.minLen || this.maxLen) {
            stringConstraints = {
                minLen: this.minLen,
                maxLen: this.maxLen,
            };
        }
        return {
            dataType: 'String',
            stringConstraints,
            mutable: this.mutable,
        };
    }
}
exports.StringAttribute = StringAttribute;
/**
 * The Number custom attribute type.
 */
class NumberAttribute {
    constructor(props = {}) {
        this.min = props === null || props === void 0 ? void 0 : props.min;
        this.max = props === null || props === void 0 ? void 0 : props.max;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        let numberConstraints;
        if (this.min || this.max) {
            numberConstraints = {
                min: this.min,
                max: this.max,
            };
        }
        return {
            dataType: 'Number',
            numberConstraints,
            mutable: this.mutable,
        };
    }
}
exports.NumberAttribute = NumberAttribute;
/**
 * The Boolean custom attribute type.
 */
class BooleanAttribute {
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        return {
            dataType: 'Boolean',
            mutable: this.mutable,
        };
    }
}
exports.BooleanAttribute = BooleanAttribute;
/**
 * The DateTime custom attribute type.
 */
class DateTimeAttribute {
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        return {
            dataType: 'DateTime',
            mutable: this.mutable,
        };
    }
}
exports.DateTimeAttribute = DateTimeAttribute;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlci1wb29sLWF0dHIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1c2VyLXBvb2wtYXR0ci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUFtQyxDQUFDLGdEQUFnRDtBQStMcEY7O0dBRUc7QUFDSCxNQUFhLGVBQWU7SUFJeEIsWUFBWSxRQUE4QixFQUFFO1FBQ3hDLElBQUksS0FBSyxDQUFDLE1BQU0sSUFBSSxDQUFDLFlBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO1lBQ3ZFLE1BQU0sSUFBSSxLQUFLLENBQUMsd0NBQXdDLEtBQUssQ0FBQyxNQUFNLElBQUksQ0FBQyxDQUFDO1NBQzdFO1FBQ0QsSUFBSSxLQUFLLENBQUMsTUFBTSxJQUFJLENBQUMsWUFBSyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLE1BQU0sR0FBRyxJQUFJLEVBQUU7WUFDMUUsTUFBTSxJQUFJLEtBQUssQ0FBQyw4Q0FBOEMsS0FBSyxDQUFDLE1BQU0sSUFBSSxDQUFDLENBQUM7U0FDbkY7UUFDRCxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxNQUFNLENBQUM7UUFDNUIsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsTUFBTSxDQUFDO1FBQzVCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sQ0FBQztJQUNsQyxDQUFDO0lBQ00sSUFBSTtRQUNQLElBQUksaUJBQXlELENBQUM7UUFDOUQsSUFBSSxJQUFJLENBQUMsTUFBTSxJQUFJLElBQUksQ0FBQyxNQUFNLEVBQUU7WUFDNUIsaUJBQWlCLEdBQUc7Z0JBQ2hCLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtnQkFDbkIsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO2FBQ3RCLENBQUM7U0FDTDtRQUNELE9BQU87WUFDSCxRQUFRLEVBQUUsUUFBUTtZQUNsQixpQkFBaUI7WUFDakIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1NBQ3hCLENBQUM7SUFDTixDQUFDO0NBQ0o7QUE3QkQsMENBNkJDO0FBcUJEOztHQUVHO0FBQ0gsTUFBYSxlQUFlO0lBSXhCLFlBQVksUUFBOEIsRUFBRTtRQUN4QyxJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxHQUFHLENBQUM7UUFDdEIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsR0FBRyxDQUFDO1FBQ3RCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sQ0FBQztJQUNsQyxDQUFDO0lBQ00sSUFBSTtRQUNQLElBQUksaUJBQXlELENBQUM7UUFDOUQsSUFBSSxJQUFJLENBQUMsR0FBRyxJQUFJLElBQUksQ0FBQyxHQUFHLEVBQUU7WUFDdEIsaUJBQWlCLEdBQUc7Z0JBQ2hCLEdBQUcsRUFBRSxJQUFJLENBQUMsR0FBRztnQkFDYixHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7YUFDaEIsQ0FBQztTQUNMO1FBQ0QsT0FBTztZQUNILFFBQVEsRUFBRSxRQUFRO1lBQ2xCLGlCQUFpQjtZQUNqQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87U0FDeEIsQ0FBQztJQUNOLENBQUM7Q0FDSjtBQXZCRCwwQ0F1QkM7QUFDRDs7R0FFRztBQUNILE1BQWEsZ0JBQWdCO0lBRXpCLFlBQVksUUFBOEIsRUFBRTtRQUN4QyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssYUFBTCxLQUFLLHVCQUFMLEtBQUssQ0FBRSxPQUFPLENBQUM7SUFDbEMsQ0FBQztJQUNNLElBQUk7UUFDUCxPQUFPO1lBQ0gsUUFBUSxFQUFFLFNBQVM7WUFDbkIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1NBQ3hCLENBQUM7SUFDTixDQUFDO0NBQ0o7QUFYRCw0Q0FXQztBQUNEOztHQUVHO0FBQ0gsTUFBYSxpQkFBaUI7SUFFMUIsWUFBWSxRQUE4QixFQUFFO1FBQ3hDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxhQUFMLEtBQUssdUJBQUwsS0FBSyxDQUFFLE9BQU8sQ0FBQztJQUNsQyxDQUFDO0lBQ00sSUFBSTtRQUNQLE9BQU87WUFDSCxRQUFRLEVBQUUsVUFBVTtZQUNwQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87U0FDeEIsQ0FBQztJQUNOLENBQUM7Q0FDSjtBQVhELDhDQVdDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVG9rZW4gfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbi8qKlxuICogVGhlIHNldCBvZiBzdGFuZGFyZCBhdHRyaWJ1dGVzIHRoYXQgY2FuIGJlIG1hcmtlZCBhcyByZXF1aXJlZCBvciBtdXRhYmxlLlxuICpcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvZ25pdG8vbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3VzZXItcG9vbC1zZXR0aW5ncy1hdHRyaWJ1dGVzLmh0bWwjY29nbml0by11c2VyLXBvb2xzLXN0YW5kYXJkLWF0dHJpYnV0ZXNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdGFuZGFyZEF0dHJpYnV0ZXMge1xuICAgIC8qKlxuICAgICAqIFRoZSB1c2VyJ3MgcG9zdGFsIGFkZHJlc3MuXG4gICAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICAgKi9cbiAgICByZWFkb25seSBhZGRyZXNzPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG4gICAgLyoqXG4gICAgICogVGhlIHVzZXIncyBiaXJ0aGRheSwgcmVwcmVzZW50ZWQgYXMgYW4gSVNPIDg2MDE6MjAwNCBmb3JtYXQuXG4gICAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICAgKi9cbiAgICByZWFkb25seSBiaXJ0aGRhdGU/OiBTdGFuZGFyZEF0dHJpYnV0ZTtcbiAgICAvKipcbiAgICAgKiBUaGUgdXNlcidzIGUtbWFpbCBhZGRyZXNzLCByZXByZXNlbnRlZCBhcyBhbiBSRkMgNTMyMiBbUkZDNTMyMl0gYWRkci1zcGVjLlxuICAgICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAgICovXG4gICAgcmVhZG9ubHkgZW1haWw/OiBTdGFuZGFyZEF0dHJpYnV0ZTtcbiAgICAvKipcbiAgICAgKiBUaGUgc3VybmFtZSBvciBsYXN0IG5hbWUgb2YgdGhlIHVzZXIuXG4gICAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICAgKi9cbiAgICByZWFkb25seSBmYW1pbHlOYW1lPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG4gICAgLyoqXG4gICAgICogVGhlIHVzZXIncyBnZW5kZXIuXG4gICAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICAgKi9cbiAgICByZWFkb25seSBnZW5kZXI/OiBTdGFuZGFyZEF0dHJpYnV0ZTtcbiAgICAvKipcbiAgICAgKiBUaGUgdXNlcidzIGZpcnN0IG5hbWUgb3IgZ2l2ZSBuYW1lLlxuICAgICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAgICovXG4gICAgcmVhZG9ubHkgZ2l2ZW5OYW1lPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG4gICAgLyoqXG4gICAgICogVGhlIHVzZXIncyBsb2NhbGUsIHJlcHJlc2VudGVkIGFzIGEgQkNQNDcgW1JGQzU2NDZdIGxhbmd1YWdlIHRhZy5cbiAgICAgKiBAZGVmYXVsdCAtIHNlZSB0aGUgZGVmYXVsdHMgdW5kZXIgYFN0YW5kYXJkQXR0cmlidXRlYFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGxvY2FsZT86IFN0YW5kYXJkQXR0cmlidXRlO1xuICAgIC8qKlxuICAgICAqIFRoZSB1c2VyJ3MgbWlkZGxlIG5hbWUuXG4gICAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICAgKi9cbiAgICByZWFkb25seSBtaWRkbGVOYW1lPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG4gICAgLyoqXG4gICAgICogVGhlIHVzZXIncyBmdWxsIG5hbWUgaW4gZGlzcGxheWFibGUgZm9ybSwgaW5jbHVkaW5nIGFsbCBuYW1lIHBhcnRzLCB0aXRsZXMgYW5kIHN1ZmZpeGVzLlxuICAgICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAgICovXG4gICAgcmVhZG9ubHkgZnVsbG5hbWU/OiBTdGFuZGFyZEF0dHJpYnV0ZTtcbiAgICAvKipcbiAgICAgKiBUaGUgdXNlcidzIG5pY2tuYW1lIG9yIGNhc3VhbCBuYW1lLlxuICAgICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmlja25hbWU/OiBTdGFuZGFyZEF0dHJpYnV0ZTtcbiAgICAvKipcbiAgICAgKiBUaGUgdXNlcidzIHRlbGVwaG9uZSBudW1iZXIuXG4gICAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICAgKi9cbiAgICByZWFkb25seSBwaG9uZU51bWJlcj86IFN0YW5kYXJkQXR0cmlidXRlO1xuICAgIC8qKlxuICAgICAqIFRoZSBVUkwgdG8gdGhlIHVzZXIncyBwcm9maWxlIHBpY3R1cmUuXG4gICAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICAgKi9cbiAgICByZWFkb25seSBwcm9maWxlUGljdHVyZT86IFN0YW5kYXJkQXR0cmlidXRlO1xuICAgIC8qKlxuICAgICAqIFRoZSB1c2VyJ3MgcHJlZmZlcmVkIHVzZXJuYW1lLCBkaWZmZXJlbnQgZnJvbSB0aGUgaW1tdXRhYmxlIHVzZXIgbmFtZS5cbiAgICAgKiBAZGVmYXVsdCAtIHNlZSB0aGUgZGVmYXVsdHMgdW5kZXIgYFN0YW5kYXJkQXR0cmlidXRlYFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByZWZlcnJlZFVzZXJuYW1lPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG4gICAgLyoqXG4gICAgICogVGhlIFVSTCB0byB0aGUgdXNlcidzIHByb2ZpbGUgcGFnZS5cbiAgICAgKiBAZGVmYXVsdCAtIHNlZSB0aGUgZGVmYXVsdHMgdW5kZXIgYFN0YW5kYXJkQXR0cmlidXRlYFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByb2ZpbGVQYWdlPzogU3RhbmRhcmRBdHRyaWJ1dGU7XG4gICAgLyoqXG4gICAgICogVGhlIHVzZXIncyB0aW1lIHpvbmUuXG4gICAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICAgKi9cbiAgICByZWFkb25seSB0aW1lem9uZT86IFN0YW5kYXJkQXR0cmlidXRlO1xuICAgIC8qKlxuICAgICAqIFRoZSB0aW1lLCB0aGUgdXNlcidzIGluZm9ybWF0aW9uIHdhcyBsYXN0IHVwZGF0ZWQuXG4gICAgICogQGRlZmF1bHQgLSBzZWUgdGhlIGRlZmF1bHRzIHVuZGVyIGBTdGFuZGFyZEF0dHJpYnV0ZWBcbiAgICAgKi9cbiAgICByZWFkb25seSBsYXN0VXBkYXRlVGltZT86IFN0YW5kYXJkQXR0cmlidXRlO1xuICAgIC8qKlxuICAgICAqIFRoZSBVUkwgdG8gdGhlIHVzZXIncyB3ZWIgcGFnZSBvciBibG9nLlxuICAgICAqIEBkZWZhdWx0IC0gc2VlIHRoZSBkZWZhdWx0cyB1bmRlciBgU3RhbmRhcmRBdHRyaWJ1dGVgXG4gICAgICovXG4gICAgcmVhZG9ubHkgd2Vic2l0ZT86IFN0YW5kYXJkQXR0cmlidXRlO1xufVxuLyoqXG4gKiBTdGFuZGFyZCBhdHRyaWJ1dGUgdGhhdCBjYW4gYmUgbWFya2VkIGFzIHJlcXVpcmVkIG9yIG11dGFibGUuXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29nbml0by9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvdXNlci1wb29sLXNldHRpbmdzLWF0dHJpYnV0ZXMuaHRtbCNjb2duaXRvLXVzZXItcG9vbHMtc3RhbmRhcmQtYXR0cmlidXRlc1xuICovXG5leHBvcnQgaW50ZXJmYWNlIFN0YW5kYXJkQXR0cmlidXRlIHtcbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgd2hldGhlciB0aGUgdmFsdWUgb2YgdGhlIGF0dHJpYnV0ZSBjYW4gYmUgY2hhbmdlZC5cbiAgICAgKiBGb3IgYW55IHVzZXIgcG9vbCBhdHRyaWJ1dGUgdGhhdCdzIG1hcHBlZCB0byBhbiBpZGVudGl0eSBwcm92aWRlciBhdHRyaWJ1dGUsIHRoaXMgbXVzdCBiZSBzZXQgdG8gYHRydWVgLlxuICAgICAqIEFtYXpvbiBDb2duaXRvIHVwZGF0ZXMgbWFwcGVkIGF0dHJpYnV0ZXMgd2hlbiB1c2VycyBzaWduIGluIHRvIHlvdXIgYXBwbGljYXRpb24gdGhyb3VnaCBhbiBpZGVudGl0eSBwcm92aWRlci5cbiAgICAgKiBJZiBhbiBhdHRyaWJ1dGUgaXMgaW1tdXRhYmxlLCBBbWF6b24gQ29nbml0byB0aHJvd3MgYW4gZXJyb3Igd2hlbiBpdCBhdHRlbXB0cyB0byB1cGRhdGUgdGhlIGF0dHJpYnV0ZS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IHRydWVcbiAgICAgKi9cbiAgICByZWFkb25seSBtdXRhYmxlPzogYm9vbGVhbjtcbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgd2hldGhlciB0aGUgYXR0cmlidXRlIGlzIHJlcXVpcmVkIHVwb24gdXNlciByZWdpc3RyYXRpb24uXG4gICAgICogSWYgdGhlIGF0dHJpYnV0ZSBpcyByZXF1aXJlZCBhbmQgdGhlIHVzZXIgZG9lcyBub3QgcHJvdmlkZSBhIHZhbHVlLCByZWdpc3RyYXRpb24gb3Igc2lnbi1pbiB3aWxsIGZhaWwuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlcXVpcmVkPzogYm9vbGVhbjtcbn1cbi8qKlxuICogUmVwcmVzZW50cyBhIGN1c3RvbSBhdHRyaWJ1dGUgdHlwZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJQ3VzdG9tQXR0cmlidXRlIHtcbiAgICAvKipcbiAgICAgKiBCaW5kIHRoaXMgY3VzdG9tIGF0dHJpYnV0ZSB0eXBlIHRvIHRoZSB2YWx1ZXMgYXMgZXhwZWN0ZWQgYnkgQ2xvdWRGb3JtYXRpb25cbiAgICAgKi9cbiAgICBiaW5kKCk6IEN1c3RvbUF0dHJpYnV0ZUNvbmZpZztcbn1cbi8qKlxuICogQ29uZmlndXJhdGlvbiB0aGF0IHdpbGwgYmUgZmVkIGludG8gQ2xvdWRGb3JtYXRpb24gZm9yIGFueSBjdXN0b20gYXR0cmlidXRlIHR5cGUuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ3VzdG9tQXR0cmlidXRlQ29uZmlnIHtcbiAgICAvLyB0c2xpbnQ6ZGlzYWJsZTptYXgtbGluZS1sZW5ndGhcbiAgICAvKipcbiAgICAgKiBUaGUgZGF0YSB0eXBlIG9mIHRoZSBjdXN0b20gYXR0cmlidXRlLlxuICAgICAqXG4gICAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29nbml0by11c2VyLWlkZW50aXR5LXBvb2xzL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX1NjaGVtYUF0dHJpYnV0ZVR5cGUuaHRtbCNDb2duaXRvVXNlclBvb2xzLVR5cGUtU2NoZW1hQXR0cmlidXRlVHlwZS1BdHRyaWJ1dGVEYXRhVHlwZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRhdGFUeXBlOiBzdHJpbmc7XG4gICAgLy8gdHNsaW50OmVuYWJsZTptYXgtbGluZS1sZW5ndGhcbiAgICAvKipcbiAgICAgKiBUaGUgY29uc3RyYWludHMgZm9yIGEgY3VzdG9tIGF0dHJpYnV0ZSBvZiAnU3RyaW5nJyBkYXRhIHR5cGUuXG4gICAgICogQGRlZmF1bHQgLSBOb25lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN0cmluZ0NvbnN0cmFpbnRzPzogU3RyaW5nQXR0cmlidXRlQ29uc3RyYWludHM7XG4gICAgLyoqXG4gICAgICogVGhlIGNvbnN0cmFpbnRzIGZvciBhIGN1c3RvbSBhdHRyaWJ1dGUgb2YgdGhlICdOdW1iZXInIGRhdGEgdHlwZS5cbiAgICAgKiBAZGVmYXVsdCAtIE5vbmUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbnVtYmVyQ29uc3RyYWludHM/OiBOdW1iZXJBdHRyaWJ1dGVDb25zdHJhaW50cztcbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgd2hldGhlciB0aGUgdmFsdWUgb2YgdGhlIGF0dHJpYnV0ZSBjYW4gYmUgY2hhbmdlZC5cbiAgICAgKiBGb3IgYW55IHVzZXIgcG9vbCBhdHRyaWJ1dGUgdGhhdCdzIG1hcHBlZCB0byBhbiBpZGVudGl0eSBwcm92aWRlciBhdHRyaWJ1dGUsIHlvdSBtdXN0IHNldCB0aGlzIHBhcmFtZXRlciB0byB0cnVlLlxuICAgICAqIEFtYXpvbiBDb2duaXRvIHVwZGF0ZXMgbWFwcGVkIGF0dHJpYnV0ZXMgd2hlbiB1c2VycyBzaWduIGluIHRvIHlvdXIgYXBwbGljYXRpb24gdGhyb3VnaCBhbiBpZGVudGl0eSBwcm92aWRlci5cbiAgICAgKiBJZiBhbiBhdHRyaWJ1dGUgaXMgaW1tdXRhYmxlLCBBbWF6b24gQ29nbml0byB0aHJvd3MgYW4gZXJyb3Igd2hlbiBpdCBhdHRlbXB0cyB0byB1cGRhdGUgdGhlIGF0dHJpYnV0ZS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IGZhbHNlXG4gICAgICovXG4gICAgcmVhZG9ubHkgbXV0YWJsZT86IGJvb2xlYW47XG59XG4vKipcbiAqIENvbnN0cmFpbnRzIHRoYXQgY2FuIGJlIGFwcGxpZWQgdG8gYSBjdXN0b20gYXR0cmlidXRlIG9mIGFueSB0eXBlLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEN1c3RvbUF0dHJpYnV0ZVByb3BzIHtcbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgd2hldGhlciB0aGUgdmFsdWUgb2YgdGhlIGF0dHJpYnV0ZSBjYW4gYmUgY2hhbmdlZC5cbiAgICAgKiBGb3IgYW55IHVzZXIgcG9vbCBhdHRyaWJ1dGUgdGhhdCdzIG1hcHBlZCB0byBhbiBpZGVudGl0eSBwcm92aWRlciBhdHRyaWJ1dGUsIHlvdSBtdXN0IHNldCB0aGlzIHBhcmFtZXRlciB0byB0cnVlLlxuICAgICAqIEFtYXpvbiBDb2duaXRvIHVwZGF0ZXMgbWFwcGVkIGF0dHJpYnV0ZXMgd2hlbiB1c2VycyBzaWduIGluIHRvIHlvdXIgYXBwbGljYXRpb24gdGhyb3VnaCBhbiBpZGVudGl0eSBwcm92aWRlci5cbiAgICAgKiBJZiBhbiBhdHRyaWJ1dGUgaXMgaW1tdXRhYmxlLCBBbWF6b24gQ29nbml0byB0aHJvd3MgYW4gZXJyb3Igd2hlbiBpdCBhdHRlbXB0cyB0byB1cGRhdGUgdGhlIGF0dHJpYnV0ZS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IGZhbHNlXG4gICAgICovXG4gICAgcmVhZG9ubHkgbXV0YWJsZT86IGJvb2xlYW47XG59XG4vKipcbiAqIENvbnN0cmFpbnRzIHRoYXQgY2FuIGJlIGFwcGxpZWQgdG8gYSBjdXN0b20gYXR0cmlidXRlIG9mIHN0cmluZyB0eXBlLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN0cmluZ0F0dHJpYnV0ZUNvbnN0cmFpbnRzIHtcbiAgICAvKipcbiAgICAgKiBNaW5pbXVtIGxlbmd0aCBvZiB0aGlzIGF0dHJpYnV0ZS5cbiAgICAgKiBAZGVmYXVsdCAwXG4gICAgICovXG4gICAgcmVhZG9ubHkgbWluTGVuPzogbnVtYmVyO1xuICAgIC8qKlxuICAgICAqIE1heGltdW0gbGVuZ3RoIG9mIHRoaXMgYXR0cmlidXRlLlxuICAgICAqIEBkZWZhdWx0IDIwNDhcbiAgICAgKi9cbiAgICByZWFkb25seSBtYXhMZW4/OiBudW1iZXI7XG59XG4vKipcbiAqIFByb3BzIGZvciBjb25zdHJ1Y3RpbmcgYSBTdHJpbmdBdHRyXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3RyaW5nQXR0cmlidXRlUHJvcHMgZXh0ZW5kcyBTdHJpbmdBdHRyaWJ1dGVDb25zdHJhaW50cywgQ3VzdG9tQXR0cmlidXRlUHJvcHMge1xufVxuLyoqXG4gKiBUaGUgU3RyaW5nIGN1c3RvbSBhdHRyaWJ1dGUgdHlwZS5cbiAqL1xuZXhwb3J0IGNsYXNzIFN0cmluZ0F0dHJpYnV0ZSBpbXBsZW1lbnRzIElDdXN0b21BdHRyaWJ1dGUge1xuICAgIHByaXZhdGUgcmVhZG9ubHkgbWluTGVuPzogbnVtYmVyO1xuICAgIHByaXZhdGUgcmVhZG9ubHkgbWF4TGVuPzogbnVtYmVyO1xuICAgIHByaXZhdGUgcmVhZG9ubHkgbXV0YWJsZT86IGJvb2xlYW47XG4gICAgY29uc3RydWN0b3IocHJvcHM6IFN0cmluZ0F0dHJpYnV0ZVByb3BzID0ge30pIHtcbiAgICAgICAgaWYgKHByb3BzLm1pbkxlbiAmJiAhVG9rZW4uaXNVbnJlc29sdmVkKHByb3BzLm1pbkxlbikgJiYgcHJvcHMubWluTGVuIDwgMCkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBtaW5MZW4gY2Fubm90IGJlIGxlc3MgdGhhbiAwICh2YWx1ZTogJHtwcm9wcy5taW5MZW59KS5gKTtcbiAgICAgICAgfVxuICAgICAgICBpZiAocHJvcHMubWF4TGVuICYmICFUb2tlbi5pc1VucmVzb2x2ZWQocHJvcHMubWF4TGVuKSAmJiBwcm9wcy5tYXhMZW4gPiAyMDQ4KSB7XG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYG1heExlbiBjYW5ub3QgYmUgZ3JlYXRlciB0aGFuIDIwNDggKHZhbHVlOiAke3Byb3BzLm1heExlbn0pLmApO1xuICAgICAgICB9XG4gICAgICAgIHRoaXMubWluTGVuID0gcHJvcHM/Lm1pbkxlbjtcbiAgICAgICAgdGhpcy5tYXhMZW4gPSBwcm9wcz8ubWF4TGVuO1xuICAgICAgICB0aGlzLm11dGFibGUgPSBwcm9wcz8ubXV0YWJsZTtcbiAgICB9XG4gICAgcHVibGljIGJpbmQoKTogQ3VzdG9tQXR0cmlidXRlQ29uZmlnIHtcbiAgICAgICAgbGV0IHN0cmluZ0NvbnN0cmFpbnRzOiBTdHJpbmdBdHRyaWJ1dGVDb25zdHJhaW50cyB8IHVuZGVmaW5lZDtcbiAgICAgICAgaWYgKHRoaXMubWluTGVuIHx8IHRoaXMubWF4TGVuKSB7XG4gICAgICAgICAgICBzdHJpbmdDb25zdHJhaW50cyA9IHtcbiAgICAgICAgICAgICAgICBtaW5MZW46IHRoaXMubWluTGVuLFxuICAgICAgICAgICAgICAgIG1heExlbjogdGhpcy5tYXhMZW4sXG4gICAgICAgICAgICB9O1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBkYXRhVHlwZTogJ1N0cmluZycsXG4gICAgICAgICAgICBzdHJpbmdDb25zdHJhaW50cyxcbiAgICAgICAgICAgIG11dGFibGU6IHRoaXMubXV0YWJsZSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4vKipcbiAqIENvbnN0cmFpbnRzIHRoYXQgY2FuIGJlIGFwcGxpZWQgdG8gYSBjdXN0b20gYXR0cmlidXRlIG9mIG51bWJlciB0eXBlLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIE51bWJlckF0dHJpYnV0ZUNvbnN0cmFpbnRzIHtcbiAgICAvKipcbiAgICAgKiBNaW5pbXVtIHZhbHVlIG9mIHRoaXMgYXR0cmlidXRlLlxuICAgICAqIEBkZWZhdWx0IC0gbm8gbWluaW11bSB2YWx1ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1pbj86IG51bWJlcjtcbiAgICAvKipcbiAgICAgKiBNYXhpbXVtIHZhbHVlIG9mIHRoaXMgYXR0cmlidXRlLlxuICAgICAqIEBkZWZhdWx0IC0gbm8gbWF4aW11bSB2YWx1ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1heD86IG51bWJlcjtcbn1cbi8qKlxuICogUHJvcHMgZm9yIE51bWJlckF0dHJcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBOdW1iZXJBdHRyaWJ1dGVQcm9wcyBleHRlbmRzIE51bWJlckF0dHJpYnV0ZUNvbnN0cmFpbnRzLCBDdXN0b21BdHRyaWJ1dGVQcm9wcyB7XG59XG4vKipcbiAqIFRoZSBOdW1iZXIgY3VzdG9tIGF0dHJpYnV0ZSB0eXBlLlxuICovXG5leHBvcnQgY2xhc3MgTnVtYmVyQXR0cmlidXRlIGltcGxlbWVudHMgSUN1c3RvbUF0dHJpYnV0ZSB7XG4gICAgcHJpdmF0ZSByZWFkb25seSBtaW4/OiBudW1iZXI7XG4gICAgcHJpdmF0ZSByZWFkb25seSBtYXg/OiBudW1iZXI7XG4gICAgcHJpdmF0ZSByZWFkb25seSBtdXRhYmxlPzogYm9vbGVhbjtcbiAgICBjb25zdHJ1Y3Rvcihwcm9wczogTnVtYmVyQXR0cmlidXRlUHJvcHMgPSB7fSkge1xuICAgICAgICB0aGlzLm1pbiA9IHByb3BzPy5taW47XG4gICAgICAgIHRoaXMubWF4ID0gcHJvcHM/Lm1heDtcbiAgICAgICAgdGhpcy5tdXRhYmxlID0gcHJvcHM/Lm11dGFibGU7XG4gICAgfVxuICAgIHB1YmxpYyBiaW5kKCk6IEN1c3RvbUF0dHJpYnV0ZUNvbmZpZyB7XG4gICAgICAgIGxldCBudW1iZXJDb25zdHJhaW50czogTnVtYmVyQXR0cmlidXRlQ29uc3RyYWludHMgfCB1bmRlZmluZWQ7XG4gICAgICAgIGlmICh0aGlzLm1pbiB8fCB0aGlzLm1heCkge1xuICAgICAgICAgICAgbnVtYmVyQ29uc3RyYWludHMgPSB7XG4gICAgICAgICAgICAgICAgbWluOiB0aGlzLm1pbixcbiAgICAgICAgICAgICAgICBtYXg6IHRoaXMubWF4LFxuICAgICAgICAgICAgfTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgZGF0YVR5cGU6ICdOdW1iZXInLFxuICAgICAgICAgICAgbnVtYmVyQ29uc3RyYWludHMsXG4gICAgICAgICAgICBtdXRhYmxlOiB0aGlzLm11dGFibGUsXG4gICAgICAgIH07XG4gICAgfVxufVxuLyoqXG4gKiBUaGUgQm9vbGVhbiBjdXN0b20gYXR0cmlidXRlIHR5cGUuXG4gKi9cbmV4cG9ydCBjbGFzcyBCb29sZWFuQXR0cmlidXRlIGltcGxlbWVudHMgSUN1c3RvbUF0dHJpYnV0ZSB7XG4gICAgcHJpdmF0ZSByZWFkb25seSBtdXRhYmxlPzogYm9vbGVhbjtcbiAgICBjb25zdHJ1Y3Rvcihwcm9wczogQ3VzdG9tQXR0cmlidXRlUHJvcHMgPSB7fSkge1xuICAgICAgICB0aGlzLm11dGFibGUgPSBwcm9wcz8ubXV0YWJsZTtcbiAgICB9XG4gICAgcHVibGljIGJpbmQoKTogQ3VzdG9tQXR0cmlidXRlQ29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGRhdGFUeXBlOiAnQm9vbGVhbicsXG4gICAgICAgICAgICBtdXRhYmxlOiB0aGlzLm11dGFibGUsXG4gICAgICAgIH07XG4gICAgfVxufVxuLyoqXG4gKiBUaGUgRGF0ZVRpbWUgY3VzdG9tIGF0dHJpYnV0ZSB0eXBlLlxuICovXG5leHBvcnQgY2xhc3MgRGF0ZVRpbWVBdHRyaWJ1dGUgaW1wbGVtZW50cyBJQ3VzdG9tQXR0cmlidXRlIHtcbiAgICBwcml2YXRlIHJlYWRvbmx5IG11dGFibGU/OiBib29sZWFuO1xuICAgIGNvbnN0cnVjdG9yKHByb3BzOiBDdXN0b21BdHRyaWJ1dGVQcm9wcyA9IHt9KSB7XG4gICAgICAgIHRoaXMubXV0YWJsZSA9IHByb3BzPy5tdXRhYmxlO1xuICAgIH1cbiAgICBwdWJsaWMgYmluZCgpOiBDdXN0b21BdHRyaWJ1dGVDb25maWcge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgZGF0YVR5cGU6ICdEYXRlVGltZScsXG4gICAgICAgICAgICBtdXRhYmxlOiB0aGlzLm11dGFibGUsXG4gICAgICAgIH07XG4gICAgfVxufVxuIl19