"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const codestar = require("./codestar.generated");
/**
 * The GitHubRepository resource
 */
class GitHubRepository extends cdk.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const resource = new codestar.CfnGitHubRepository(this, 'Resource', {
            repositoryOwner: props.owner,
            repositoryName: props.repositoryName,
            repositoryAccessToken: props.accessToken.toString(),
            code: {
                s3: {
                    bucket: props.contentsBucket.bucketName,
                    key: props.contentsKey,
                    objectVersion: props.contentsS3Version,
                },
            },
            enableIssues: (_a = props.enableIssues) !== null && _a !== void 0 ? _a : true,
            isPrivate: props.visibility === RepositoryVisibility.PRIVATE ? true : false,
            repositoryDescription: props.description,
        });
        this.owner = cdk.Fn.select(0, cdk.Fn.split('/', resource.ref));
        this.repo = cdk.Fn.select(1, cdk.Fn.split('/', resource.ref));
    }
}
exports.GitHubRepository = GitHubRepository;
/**
 * Visibility of the GitHubRepository
 */
var RepositoryVisibility;
(function (RepositoryVisibility) {
    /**
     * private repository
     */
    RepositoryVisibility[RepositoryVisibility["PRIVATE"] = 0] = "PRIVATE";
    /**
     * public repository
     */
    RepositoryVisibility[RepositoryVisibility["PUBLIC"] = 1] = "PUBLIC";
})(RepositoryVisibility = exports.RepositoryVisibility || (exports.RepositoryVisibility = {}));
//# sourceMappingURL=data:application/json;base64,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