"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * This class is private to the aws-codepipeline package.
 */
class FullActionDescriptor {
    constructor(props) {
        this.action = props.action;
        const actionProperties = props.action.actionProperties;
        this.actionName = actionProperties.actionName;
        this.category = actionProperties.category;
        this.owner = actionProperties.owner || 'AWS';
        this.provider = actionProperties.provider;
        this.version = actionProperties.version || '1';
        this.runOrder = actionProperties.runOrder === undefined ? 1 : actionProperties.runOrder;
        this.artifactBounds = actionProperties.artifactBounds;
        this.namespace = actionProperties.variablesNamespace;
        this.inputs = deduplicateArtifacts(actionProperties.inputs);
        this.outputs = deduplicateArtifacts(actionProperties.outputs);
        this.region = props.actionRegion || actionProperties.region;
        this.role = actionProperties.role !== undefined ? actionProperties.role : props.actionRole;
        this.configuration = props.actionConfig.configuration;
    }
}
exports.FullActionDescriptor = FullActionDescriptor;
function deduplicateArtifacts(artifacts) {
    const ret = new Array();
    for (const artifact of artifacts || []) {
        if (artifact.artifactName) {
            if (ret.find(a => a.artifactName === artifact.artifactName)) {
                continue;
            }
        }
        else {
            if (ret.find(a => a === artifact)) {
                continue;
            }
        }
        ret.push(artifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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