"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends cdk.Construct {
    constructor(parent, id, props) {
        super(parent, id);
        new codepipeline.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: props.actionProperties === undefined ? undefined : props.actionProperties.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
exports.CustomActionRegistration = CustomActionRegistration;
//# sourceMappingURL=data:application/json;base64,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