"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The ArtifactBounds that make sense for source Actions -
 * they don't have any inputs, and have exactly one output.
 */
function sourceArtifactBounds() {
    return {
        minInputs: 0,
        maxInputs: 0,
        minOutputs: 1,
        maxOutputs: 1,
    };
}
exports.sourceArtifactBounds = sourceArtifactBounds;
/**
 * The ArtifactBounds that make sense for deploy Actions -
 * they have exactly one input, and don't produce any outputs.
 */
function deployArtifactBounds() {
    return {
        minInputs: 1,
        maxInputs: 1,
        minOutputs: 0,
        maxOutputs: 0,
    };
}
exports.deployArtifactBounds = deployArtifactBounds;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tbW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQ0E7OztHQUdHO0FBQ0gsU0FBZ0Isb0JBQW9CO0lBQ2hDLE9BQU87UUFDSCxTQUFTLEVBQUUsQ0FBQztRQUNaLFNBQVMsRUFBRSxDQUFDO1FBQ1osVUFBVSxFQUFFLENBQUM7UUFDYixVQUFVLEVBQUUsQ0FBQztLQUNoQixDQUFDO0FBQ04sQ0FBQztBQVBELG9EQU9DO0FBQ0Q7OztHQUdHO0FBQ0gsU0FBZ0Isb0JBQW9CO0lBQ2hDLE9BQU87UUFDSCxTQUFTLEVBQUUsQ0FBQztRQUNaLFNBQVMsRUFBRSxDQUFDO1FBQ1osVUFBVSxFQUFFLENBQUM7UUFDYixVQUFVLEVBQUUsQ0FBQztLQUNoQixDQUFDO0FBQ04sQ0FBQztBQVBELG9EQU9DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY29kZXBpcGVsaW5lIGZyb20gXCIuLi8uLi9hd3MtY29kZXBpcGVsaW5lXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtY29kZXBpcGVsaW5lJ1xuLyoqXG4gKiBUaGUgQXJ0aWZhY3RCb3VuZHMgdGhhdCBtYWtlIHNlbnNlIGZvciBzb3VyY2UgQWN0aW9ucyAtXG4gKiB0aGV5IGRvbid0IGhhdmUgYW55IGlucHV0cywgYW5kIGhhdmUgZXhhY3RseSBvbmUgb3V0cHV0LlxuICovXG5leHBvcnQgZnVuY3Rpb24gc291cmNlQXJ0aWZhY3RCb3VuZHMoKTogY29kZXBpcGVsaW5lLkFjdGlvbkFydGlmYWN0Qm91bmRzIHtcbiAgICByZXR1cm4ge1xuICAgICAgICBtaW5JbnB1dHM6IDAsXG4gICAgICAgIG1heElucHV0czogMCxcbiAgICAgICAgbWluT3V0cHV0czogMSxcbiAgICAgICAgbWF4T3V0cHV0czogMSxcbiAgICB9O1xufVxuLyoqXG4gKiBUaGUgQXJ0aWZhY3RCb3VuZHMgdGhhdCBtYWtlIHNlbnNlIGZvciBkZXBsb3kgQWN0aW9ucyAtXG4gKiB0aGV5IGhhdmUgZXhhY3RseSBvbmUgaW5wdXQsIGFuZCBkb24ndCBwcm9kdWNlIGFueSBvdXRwdXRzLlxuICovXG5leHBvcnQgZnVuY3Rpb24gZGVwbG95QXJ0aWZhY3RCb3VuZHMoKTogY29kZXBpcGVsaW5lLkFjdGlvbkFydGlmYWN0Qm91bmRzIHtcbiAgICByZXR1cm4ge1xuICAgICAgICBtaW5JbnB1dHM6IDEsXG4gICAgICAgIG1heElucHV0czogMSxcbiAgICAgICAgbWluT3V0cHV0czogMCxcbiAgICAgICAgbWF4T3V0cHV0czogMCxcbiAgICB9O1xufVxuIl19