"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("../../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const action_1 = require("../action");
/**
 * Deploys the skill to Alexa
 */
class AlexaSkillDeployAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.DEPLOY,
            owner: 'ThirdParty',
            provider: 'AlexaSkillsKit',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 2,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: getInputs(props),
        });
        this.props = props;
    }
    bound(_scope, _stage, _options) {
        return {
            configuration: {
                ClientId: this.props.clientId,
                ClientSecret: this.props.clientSecret,
                RefreshToken: this.props.refreshToken,
                SkillId: this.props.skillId,
            },
        };
    }
}
exports.AlexaSkillDeployAction = AlexaSkillDeployAction;
function getInputs(props) {
    const ret = [props.input];
    if (props.parameterOverridesArtifact) {
        ret.push(props.parameterOverridesArtifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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