"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for an ECS Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom ECS Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class EcsDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom ECS deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromEcsDeploymentConfigName(_scope, _id, ecsDeploymentConfigName) {
        return deploymentConfig(ecsDeploymentConfigName);
    }
}
exports.EcsDeploymentConfig = EcsDeploymentConfig;
EcsDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.ECSAllAtOnce');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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