"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
/**
 * Fields of CloudWatch Events that change references
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type
 */
class ReferenceEvent {
    /**
     * The type of reference event
     *
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     */
    static get eventType() {
        return events.EventField.fromPath('$.detail.event');
    }
    /**
     * Name of the CodeCommit repository
     */
    static get repositoryName() {
        return events.EventField.fromPath('$.detail.repositoryName');
    }
    /**
     * Id of the CodeCommit repository
     */
    static get repositoryId() {
        return events.EventField.fromPath('$.detail.repositoryId');
    }
    /**
     * Type of reference changed
     *
     * 'branch' or 'tag'
     */
    static get referenceType() {
        return events.EventField.fromPath('$.detail.referenceType');
    }
    /**
     * Name of reference changed (branch or tag name)
     */
    static get referenceName() {
        return events.EventField.fromPath('$.detail.referenceName');
    }
    /**
     * Full reference name
     *
     * For example, 'refs/tags/myTag'
     */
    static get referenceFullName() {
        return events.EventField.fromPath('$.detail.referenceFullName');
    }
    /**
     * Commit id this reference now points to
     */
    static get commitId() {
        return events.EventField.fromPath('$.detail.commitId');
    }
    constructor() {
    }
}
exports.ReferenceEvent = ReferenceEvent;
//# sourceMappingURL=data:application/json;base64,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