"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const codebuild_generated_1 = require("./codebuild.generated");
/**
 * The source credentials used when contacting the GitHub API.
 *
 * **Note**: CodeBuild only allows a single credential for GitHub
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @resource AWS::CodeBuild::SourceCredential
 */
class GitHubSourceCredentials extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'GITHUB',
            authType: 'PERSONAL_ACCESS_TOKEN',
            token: props.accessToken.toString(),
        });
    }
}
exports.GitHubSourceCredentials = GitHubSourceCredentials;
/**
 * The source credentials used when contacting the GitHub Enterprise API.
 *
 * **Note**: CodeBuild only allows a single credential for GitHub Enterprise
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @resource AWS::CodeBuild::SourceCredential
 */
class GitHubEnterpriseSourceCredentials extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'GITHUB_ENTERPRISE',
            authType: 'PERSONAL_ACCESS_TOKEN',
            token: props.accessToken.toString(),
        });
    }
}
exports.GitHubEnterpriseSourceCredentials = GitHubEnterpriseSourceCredentials;
/**
 * The source credentials used when contacting the BitBucket API.
 *
 * **Note**: CodeBuild only allows a single credential for BitBucket
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @resource AWS::CodeBuild::SourceCredential
 */
class BitBucketSourceCredentials extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'BITBUCKET',
            authType: 'BASIC_AUTH',
            username: props.username.toString(),
            token: props.password.toString(),
        });
    }
}
exports.BitBucketSourceCredentials = BitBucketSourceCredentials;
//# sourceMappingURL=data:application/json;base64,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