"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
// this file contains a bunch of functions shared
// between Project and ResourceGroup,
// which we don't want to make part of the public API of this module
function renderReportGroupArn(scope, reportGroupName) {
    return cdk.Stack.of(scope).formatArn(reportGroupArnComponents(reportGroupName));
}
exports.renderReportGroupArn = renderReportGroupArn;
function reportGroupArnComponents(reportGroupName) {
    return {
        service: 'codebuild',
        resource: 'report-group',
        resourceName: reportGroupName,
    };
}
exports.reportGroupArnComponents = reportGroupArnComponents;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVwb3J0LWdyb3VwLXV0aWxzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicmVwb3J0LWdyb3VwLXV0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsa0NBQWtDLENBQUMsZ0RBQWdEO0FBQ25GLGlEQUFpRDtBQUNqRCxxQ0FBcUM7QUFDckMsb0VBQW9FO0FBQ3BFLFNBQWdCLG9CQUFvQixDQUFDLEtBQW9CLEVBQUUsZUFBdUI7SUFDOUUsT0FBTyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxTQUFTLENBQUMsd0JBQXdCLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztBQUNwRixDQUFDO0FBRkQsb0RBRUM7QUFDRCxTQUFnQix3QkFBd0IsQ0FBQyxlQUF1QjtJQUM1RCxPQUFPO1FBQ0gsT0FBTyxFQUFFLFdBQVc7UUFDcEIsUUFBUSxFQUFFLGNBQWM7UUFDeEIsWUFBWSxFQUFFLGVBQWU7S0FDaEMsQ0FBQztBQUNOLENBQUM7QUFORCw0REFNQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbi8vIHRoaXMgZmlsZSBjb250YWlucyBhIGJ1bmNoIG9mIGZ1bmN0aW9ucyBzaGFyZWRcbi8vIGJldHdlZW4gUHJvamVjdCBhbmQgUmVzb3VyY2VHcm91cCxcbi8vIHdoaWNoIHdlIGRvbid0IHdhbnQgdG8gbWFrZSBwYXJ0IG9mIHRoZSBwdWJsaWMgQVBJIG9mIHRoaXMgbW9kdWxlXG5leHBvcnQgZnVuY3Rpb24gcmVuZGVyUmVwb3J0R3JvdXBBcm4oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIHJlcG9ydEdyb3VwTmFtZTogc3RyaW5nKTogc3RyaW5nIHtcbiAgICByZXR1cm4gY2RrLlN0YWNrLm9mKHNjb3BlKS5mb3JtYXRBcm4ocmVwb3J0R3JvdXBBcm5Db21wb25lbnRzKHJlcG9ydEdyb3VwTmFtZSkpO1xufVxuZXhwb3J0IGZ1bmN0aW9uIHJlcG9ydEdyb3VwQXJuQ29tcG9uZW50cyhyZXBvcnRHcm91cE5hbWU6IHN0cmluZyk6IGNkay5Bcm5Db21wb25lbnRzIHtcbiAgICByZXR1cm4ge1xuICAgICAgICBzZXJ2aWNlOiAnY29kZWJ1aWxkJyxcbiAgICAgICAgcmVzb3VyY2U6ICdyZXBvcnQtZ3JvdXAnLFxuICAgICAgICByZXNvdXJjZU5hbWU6IHJlcG9ydEdyb3VwTmFtZSxcbiAgICB9O1xufVxuIl19