"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const source_1 = require("./source");
const source_types_1 = require("./source-types");
/**
 * A `NO_SOURCE` CodeBuild Project Source definition.
 * This is the default source type,
 * if none was specified when creating the Project.
 * *Note*: the `NO_SOURCE` type cannot be used as a secondary source,
 * and because of that, you're not allowed to specify an identifier for it.
 *
 * This class is private to the aws-codebuild package.
 */
class NoSource extends source_1.Source {
    constructor() {
        super({});
        this.type = source_types_1.NO_SOURCE_TYPE;
    }
}
exports.NoSource = NoSource;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm8tc291cmNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibm8tc291cmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEscUNBQWtDO0FBQ2xDLGlEQUFnRDtBQUNoRDs7Ozs7Ozs7R0FRRztBQUNILE1BQWEsUUFBUyxTQUFRLGVBQU07SUFFaEM7UUFDSSxLQUFLLENBQUMsRUFBRSxDQUFDLENBQUM7UUFGRSxTQUFJLEdBQUcsNkJBQWMsQ0FBQztJQUd0QyxDQUFDO0NBQ0o7QUFMRCw0QkFLQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFNvdXJjZSB9IGZyb20gJy4vc291cmNlJztcbmltcG9ydCB7IE5PX1NPVVJDRV9UWVBFIH0gZnJvbSAnLi9zb3VyY2UtdHlwZXMnO1xuLyoqXG4gKiBBIGBOT19TT1VSQ0VgIENvZGVCdWlsZCBQcm9qZWN0IFNvdXJjZSBkZWZpbml0aW9uLlxuICogVGhpcyBpcyB0aGUgZGVmYXVsdCBzb3VyY2UgdHlwZSxcbiAqIGlmIG5vbmUgd2FzIHNwZWNpZmllZCB3aGVuIGNyZWF0aW5nIHRoZSBQcm9qZWN0LlxuICogKk5vdGUqOiB0aGUgYE5PX1NPVVJDRWAgdHlwZSBjYW5ub3QgYmUgdXNlZCBhcyBhIHNlY29uZGFyeSBzb3VyY2UsXG4gKiBhbmQgYmVjYXVzZSBvZiB0aGF0LCB5b3UncmUgbm90IGFsbG93ZWQgdG8gc3BlY2lmeSBhbiBpZGVudGlmaWVyIGZvciBpdC5cbiAqXG4gKiBUaGlzIGNsYXNzIGlzIHByaXZhdGUgdG8gdGhlIGF3cy1jb2RlYnVpbGQgcGFja2FnZS5cbiAqL1xuZXhwb3J0IGNsYXNzIE5vU291cmNlIGV4dGVuZHMgU291cmNlIHtcbiAgICBwdWJsaWMgcmVhZG9ubHkgdHlwZSA9IE5PX1NPVVJDRV9UWVBFO1xuICAgIGNvbnN0cnVjdG9yKCkge1xuICAgICAgICBzdXBlcih7fSk7XG4gICAgfVxufVxuIl19