"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
/**
 * Event fields for the CodeBuild "state change" event
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 */
class StateChangeEvent {
    /**
     * The triggering build's status
     */
    static get buildStatus() {
        return events.EventField.fromPath('$.detail.build-status');
    }
    /**
     * The triggering build's project name
     */
    static get projectName() {
        return events.EventField.fromPath('$.detail.project-name');
    }
    /**
     * Return the build id
     */
    static get buildId() {
        return events.EventField.fromPath('$.detail.build-id');
    }
    static get currentPhase() {
        return events.EventField.fromPath('$.detail.current-phase');
    }
    constructor() {
    }
}
exports.StateChangeEvent = StateChangeEvent;
/**
 * Event fields for the CodeBuild "phase change" event
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 */
class PhaseChangeEvent {
    /**
     * The triggering build's project name
     */
    static get projectName() {
        return events.EventField.fromPath('$.detail.project-name');
    }
    /**
     * The triggering build's id
     */
    static get buildId() {
        return events.EventField.fromPath('$.detail.build-id');
    }
    /**
     * The phase that was just completed
     */
    static get completedPhase() {
        return events.EventField.fromPath('$.detail.completed-phase');
    }
    /**
     * The status of the completed phase
     */
    static get completedPhaseStatus() {
        return events.EventField.fromPath('$.detail.completed-phase-status');
    }
    /**
     * The duration of the completed phase
     */
    static get completedPhaseDurationSeconds() {
        return events.EventField.fromPath('$.detail.completed-phase-duration-seconds');
    }
    /**
     * Whether the build is complete
     */
    static get buildComplete() {
        return events.EventField.fromPath('$.detail.build-complete');
    }
    constructor() {
    }
}
exports.PhaseChangeEvent = PhaseChangeEvent;
//# sourceMappingURL=data:application/json;base64,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