"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Use an ApplicationAutoScaling StepScalingAction as an Alarm Action
 */
class ApplicationScalingAction {
    constructor(stepScalingAction) {
        this.stepScalingAction = stepScalingAction;
    }
    /**
     * Returns an alarm action configuration to use an ApplicationScaling StepScalingAction
     * as an alarm action
     */
    bind(_scope, _alarm) {
        return { alarmActionArn: this.stepScalingAction.scalingPolicyArn };
    }
}
exports.ApplicationScalingAction = ApplicationScalingAction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwc2NhbGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwcHNjYWxpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFHQTs7R0FFRztBQUNILE1BQWEsd0JBQXdCO0lBQ2pDLFlBQTZCLGlCQUErQztRQUEvQyxzQkFBaUIsR0FBakIsaUJBQWlCLENBQThCO0lBQzVFLENBQUM7SUFDRDs7O09BR0c7SUFDSSxJQUFJLENBQUMsTUFBcUIsRUFBRSxNQUF5QjtRQUN4RCxPQUFPLEVBQUUsY0FBYyxFQUFFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO0lBQ3ZFLENBQUM7Q0FDSjtBQVZELDREQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYXBwc2NhbGluZyBmcm9tIFwiLi4vLi4vYXdzLWFwcGxpY2F0aW9uYXV0b3NjYWxpbmdcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1hcHBsaWNhdGlvbmF1dG9zY2FsaW5nJ1xuaW1wb3J0ICogYXMgY2xvdWR3YXRjaCBmcm9tIFwiLi4vLi4vYXdzLWNsb3Vkd2F0Y2hcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZHdhdGNoJ1xuaW1wb3J0ICogYXMgY2RrIGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuLyoqXG4gKiBVc2UgYW4gQXBwbGljYXRpb25BdXRvU2NhbGluZyBTdGVwU2NhbGluZ0FjdGlvbiBhcyBhbiBBbGFybSBBY3Rpb25cbiAqL1xuZXhwb3J0IGNsYXNzIEFwcGxpY2F0aW9uU2NhbGluZ0FjdGlvbiBpbXBsZW1lbnRzIGNsb3Vkd2F0Y2guSUFsYXJtQWN0aW9uIHtcbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHN0ZXBTY2FsaW5nQWN0aW9uOiBhcHBzY2FsaW5nLlN0ZXBTY2FsaW5nQWN0aW9uKSB7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIFJldHVybnMgYW4gYWxhcm0gYWN0aW9uIGNvbmZpZ3VyYXRpb24gdG8gdXNlIGFuIEFwcGxpY2F0aW9uU2NhbGluZyBTdGVwU2NhbGluZ0FjdGlvblxuICAgICAqIGFzIGFuIGFsYXJtIGFjdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBiaW5kKF9zY29wZTogY2RrLkNvbnN0cnVjdCwgX2FsYXJtOiBjbG91ZHdhdGNoLklBbGFybSk6IGNsb3Vkd2F0Y2guQWxhcm1BY3Rpb25Db25maWcge1xuICAgICAgICByZXR1cm4geyBhbGFybUFjdGlvbkFybjogdGhpcy5zdGVwU2NhbGluZ0FjdGlvbi5zY2FsaW5nUG9saWN5QXJuIH07XG4gICAgfVxufVxuIl19