"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * A CloudFormation nested stack.
 *
 * When you apply template changes to update a top-level stack, CloudFormation
 * updates the top-level stack and initiates an update to its nested stacks.
 * CloudFormation updates the resources of modified nested stacks, but does not
 * update the resources of unmodified nested stacks.
 *
 * Furthermore, this stack will not be treated as an independent deployment
 * artifact (won't be listed in "cdk list" or deployable through "cdk deploy"),
 * but rather only synthesized as a template and uploaded as an asset to S3.
 *
 * Cross references of resource attributes between the parent stack and the
 * nested stack will automatically be translated to stack parameters and
 * outputs.
 *
 * @experimental
 */
class NestedStack extends core.NestedStack {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            parameters: props.parameters,
            timeout: props.timeout,
            notificationArns: props.notifications ? props.notifications.map(n => n.topicArn) : undefined,
        });
    }
}
exports.NestedStack = NestedStack;
//# sourceMappingURL=data:application/json;base64,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