"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const integration_1 = require("../integration");
const route_1 = require("../route");
/**
 * The HTTP Proxy integration resource for HTTP API
 */
class HttpProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(_) {
        var _a;
        return {
            method: (_a = this.props.method) !== null && _a !== void 0 ? _a : route_1.HttpMethod.ANY,
            payloadFormatVersion: integration_1.PayloadFormatVersion.VERSION_1_0,
            type: integration_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.props.url,
        };
    }
}
exports.HttpProxyIntegration = HttpProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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