"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Supported integration types
 */
var HttpIntegrationType;
(function (HttpIntegrationType) {
    /**
     * Integration type is a Lambda proxy
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["LAMBDA_PROXY"] = "AWS_PROXY";
    /**
     * Integration type is an HTTP proxy
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     */
    HttpIntegrationType["HTTP_PROXY"] = "HTTP_PROXY";
})(HttpIntegrationType = exports.HttpIntegrationType || (exports.HttpIntegrationType = {}));
/**
 * Payload format version for lambda proxy integration
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
 */
class PayloadFormatVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * A custom payload version.
     * Typically used if there is a version number that the CDK doesn't support yet
     */
    static custom(version) {
        return new PayloadFormatVersion(version);
    }
}
exports.PayloadFormatVersion = PayloadFormatVersion;
/** Version 1.0 */
PayloadFormatVersion.VERSION_1_0 = new PayloadFormatVersion('1.0');
/** Version 2.0 */
PayloadFormatVersion.VERSION_2_0 = new PayloadFormatVersion('2.0');
/**
 * The integration for an API route.
 * @resource AWS::ApiGatewayV2::Integration
 */
class HttpIntegration extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const integ = new apigatewayv2_generated_1.CfnIntegration(this, 'Resource', {
            apiId: props.httpApi.httpApiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
            integrationMethod: props.method,
            payloadFormatVersion: (_a = props.payloadFormatVersion) === null || _a === void 0 ? void 0 : _a.version,
        });
        this.integrationId = integ.ref;
        this.httpApi = props.httpApi;
    }
}
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,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