"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const integrations_1 = require("./integrations");
const restapi_1 = require("./restapi");
/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 *
 * Use the `proxy` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 */
class LambdaRestApi extends restapi_1.RestApi {
    constructor(scope, id, props) {
        if ((props.options && props.options.defaultIntegration) || props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Lambda integration is automatically defined');
        }
        super(scope, id, {
            defaultIntegration: new integrations_1.LambdaIntegration(props.handler),
            ...props.options,
            ...props,
        });
        if (props.proxy !== false) {
            this.root.addProxy();
            // Make sure users cannot call any other resource adding function
            this.root.addResource = addResourceThrows;
            this.root.addMethod = addMethodThrows;
            this.root.addProxy = addProxyThrows;
        }
    }
}
exports.LambdaRestApi = LambdaRestApi;
function addResourceThrows() {
    throw new Error('Cannot call \'addResource\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addMethodThrows() {
    throw new Error('Cannot call \'addMethod\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addProxyThrows() {
    throw new Error('Cannot call \'addProxy\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
//# sourceMappingURL=data:application/json;base64,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