"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const integration_1 = require("../integration");
/**
 * You can integrate an API method with an HTTP endpoint using the HTTP proxy
 * integration or the HTTP custom integration,.
 *
 * With the proxy integration, the setup is simple. You only need to set the
 * HTTP method and the HTTP endpoint URI, according to the backend requirements,
 * if you are not concerned with content encoding or caching.
 *
 * With the custom integration, the setup is more involved. In addition to the
 * proxy integration setup steps, you need to specify how the incoming request
 * data is mapped to the integration request and how the resulting integration
 * response data is mapped to the method response.
 */
class HttpIntegration extends integration_1.Integration {
    constructor(url, props = {}) {
        const proxy = props.proxy !== undefined ? props.proxy : true;
        const method = props.httpMethod || 'GET';
        super({
            type: proxy ? integration_1.IntegrationType.HTTP_PROXY : integration_1.IntegrationType.HTTP,
            integrationHttpMethod: method,
            uri: url,
            options: props.options,
        });
    }
}
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHR0cC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImh0dHAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnREFBa0Y7QUFxQmxGOzs7Ozs7Ozs7Ozs7R0FZRztBQUNILE1BQWEsZUFBZ0IsU0FBUSx5QkFBVztJQUM1QyxZQUFZLEdBQVcsRUFBRSxRQUE4QixFQUFFO1FBQ3JELE1BQU0sS0FBSyxHQUFHLEtBQUssQ0FBQyxLQUFLLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7UUFDN0QsTUFBTSxNQUFNLEdBQUcsS0FBSyxDQUFDLFVBQVUsSUFBSSxLQUFLLENBQUM7UUFDekMsS0FBSyxDQUFDO1lBQ0YsSUFBSSxFQUFFLEtBQUssQ0FBQyxDQUFDLENBQUMsNkJBQWUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLDZCQUFlLENBQUMsSUFBSTtZQUMvRCxxQkFBcUIsRUFBRSxNQUFNO1lBQzdCLEdBQUcsRUFBRSxHQUFHO1lBQ1IsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPO1NBQ3pCLENBQUMsQ0FBQztJQUNQLENBQUM7Q0FDSjtBQVhELDBDQVdDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW50ZWdyYXRpb24sIEludGVncmF0aW9uT3B0aW9ucywgSW50ZWdyYXRpb25UeXBlIH0gZnJvbSAnLi4vaW50ZWdyYXRpb24nO1xuZXhwb3J0IGludGVyZmFjZSBIdHRwSW50ZWdyYXRpb25Qcm9wcyB7XG4gICAgLyoqXG4gICAgICogRGV0ZXJtaW5lcyB3aGV0aGVyIHRvIHVzZSBwcm94eSBpbnRlZ3JhdGlvbiBvciBjdXN0b20gaW50ZWdyYXRpb24uXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCB0cnVlXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJveHk/OiBib29sZWFuO1xuICAgIC8qKlxuICAgICAqIEhUVFAgbWV0aG9kIHRvIHVzZSB3aGVuIGludm9raW5nIHRoZSBiYWNrZW5kIFVSTC5cbiAgICAgKiBAZGVmYXVsdCBHRVRcbiAgICAgKi9cbiAgICByZWFkb25seSBodHRwTWV0aG9kPzogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIEludGVncmF0aW9uIG9wdGlvbnMsIHN1Y2ggYXMgcmVxdWVzdC9yZXNvcG5zZSBtYXBwaW5nLCBjb250ZW50IGhhbmRsaW5nLFxuICAgICAqIGV0Yy5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IGRlZmF1bHRzIGJhc2VkIG9uIGBJbnRlZ3JhdGlvbk9wdGlvbnNgIGRlZmF1bHRzXG4gICAgICovXG4gICAgcmVhZG9ubHkgb3B0aW9ucz86IEludGVncmF0aW9uT3B0aW9ucztcbn1cbi8qKlxuICogWW91IGNhbiBpbnRlZ3JhdGUgYW4gQVBJIG1ldGhvZCB3aXRoIGFuIEhUVFAgZW5kcG9pbnQgdXNpbmcgdGhlIEhUVFAgcHJveHlcbiAqIGludGVncmF0aW9uIG9yIHRoZSBIVFRQIGN1c3RvbSBpbnRlZ3JhdGlvbiwuXG4gKlxuICogV2l0aCB0aGUgcHJveHkgaW50ZWdyYXRpb24sIHRoZSBzZXR1cCBpcyBzaW1wbGUuIFlvdSBvbmx5IG5lZWQgdG8gc2V0IHRoZVxuICogSFRUUCBtZXRob2QgYW5kIHRoZSBIVFRQIGVuZHBvaW50IFVSSSwgYWNjb3JkaW5nIHRvIHRoZSBiYWNrZW5kIHJlcXVpcmVtZW50cyxcbiAqIGlmIHlvdSBhcmUgbm90IGNvbmNlcm5lZCB3aXRoIGNvbnRlbnQgZW5jb2Rpbmcgb3IgY2FjaGluZy5cbiAqXG4gKiBXaXRoIHRoZSBjdXN0b20gaW50ZWdyYXRpb24sIHRoZSBzZXR1cCBpcyBtb3JlIGludm9sdmVkLiBJbiBhZGRpdGlvbiB0byB0aGVcbiAqIHByb3h5IGludGVncmF0aW9uIHNldHVwIHN0ZXBzLCB5b3UgbmVlZCB0byBzcGVjaWZ5IGhvdyB0aGUgaW5jb21pbmcgcmVxdWVzdFxuICogZGF0YSBpcyBtYXBwZWQgdG8gdGhlIGludGVncmF0aW9uIHJlcXVlc3QgYW5kIGhvdyB0aGUgcmVzdWx0aW5nIGludGVncmF0aW9uXG4gKiByZXNwb25zZSBkYXRhIGlzIG1hcHBlZCB0byB0aGUgbWV0aG9kIHJlc3BvbnNlLlxuICovXG5leHBvcnQgY2xhc3MgSHR0cEludGVncmF0aW9uIGV4dGVuZHMgSW50ZWdyYXRpb24ge1xuICAgIGNvbnN0cnVjdG9yKHVybDogc3RyaW5nLCBwcm9wczogSHR0cEludGVncmF0aW9uUHJvcHMgPSB7fSkge1xuICAgICAgICBjb25zdCBwcm94eSA9IHByb3BzLnByb3h5ICE9PSB1bmRlZmluZWQgPyBwcm9wcy5wcm94eSA6IHRydWU7XG4gICAgICAgIGNvbnN0IG1ldGhvZCA9IHByb3BzLmh0dHBNZXRob2QgfHwgJ0dFVCc7XG4gICAgICAgIHN1cGVyKHtcbiAgICAgICAgICAgIHR5cGU6IHByb3h5ID8gSW50ZWdyYXRpb25UeXBlLkhUVFBfUFJPWFkgOiBJbnRlZ3JhdGlvblR5cGUuSFRUUCxcbiAgICAgICAgICAgIGludGVncmF0aW9uSHR0cE1ldGhvZDogbWV0aG9kLFxuICAgICAgICAgICAgdXJpOiB1cmwsXG4gICAgICAgICAgICBvcHRpb25zOiBwcm9wcy5vcHRpb25zLFxuICAgICAgICB9KTtcbiAgICB9XG59XG4iXX0=