"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
/**
 * This resource creates a base path that clients who call your API must use in
 * the invocation URL.
 *
 * Unless you're importing a domain with `DomainName.fromDomainNameAttributes()`,
 * you can use `DomainName.addBasePathMapping()` to define mappings.
 */
class BasePathMapping extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        if (props.basePath && !core_1.Token.isUnresolved(props.basePath)) {
            if (!props.basePath.match(/^[a-z0-9$_.+!*'()-]+$/)) {
                throw new Error(`A base path may only contain letters, numbers, and one of "$-_.+!*'()", received: ${props.basePath}`);
            }
        }
        // if restApi is an owned API and it has a deployment stage, map all requests
        // to that stage. otherwise, the stage will have to be specified in the URL.
        const stage = (_a = props.stage) !== null && _a !== void 0 ? _a : (props.restApi instanceof restapi_1.RestApi
            ? props.restApi.deploymentStage
            : undefined);
        new apigateway_generated_1.CfnBasePathMapping(this, 'Resource', {
            basePath: props.basePath,
            domainName: props.domainName.domainName,
            restApiId: props.restApi.restApiId,
            stage: stage && stage.stageName,
        });
    }
}
exports.BasePathMapping = BasePathMapping;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS1wYXRoLW1hcHBpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJiYXNlLXBhdGgtbWFwcGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHFDQUF3RCxDQUFDLGdEQUFnRDtBQUN6RyxpRUFBNEQ7QUFFNUQsdUNBQThDO0FBNkI5Qzs7Ozs7O0dBTUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEsZUFBUTtJQUN6QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTJCOztRQUNqRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksS0FBSyxDQUFDLFFBQVEsSUFBSSxDQUFDLFlBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFO1lBQ3ZELElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQyxFQUFFO2dCQUNoRCxNQUFNLElBQUksS0FBSyxDQUFDLHFGQUFxRixLQUFLLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQzthQUMxSDtTQUNKO1FBQ0QsNkVBQTZFO1FBQzdFLDRFQUE0RTtRQUM1RSxNQUFNLEtBQUssU0FBRyxLQUFLLENBQUMsS0FBSyxtQ0FBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLFlBQVksaUJBQU87WUFDMUQsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsZUFBZTtZQUMvQixDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDakIsSUFBSSx5Q0FBa0IsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3JDLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxVQUFVO1lBQ3ZDLFNBQVMsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFNBQVM7WUFDbEMsS0FBSyxFQUFFLEtBQUssSUFBSSxLQUFLLENBQUMsU0FBUztTQUNsQyxDQUFDLENBQUM7SUFDUCxDQUFDO0NBQ0o7QUFwQkQsMENBb0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0LCBSZXNvdXJjZSwgVG9rZW4gfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IENmbkJhc2VQYXRoTWFwcGluZyB9IGZyb20gJy4vYXBpZ2F0ZXdheS5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSURvbWFpbk5hbWUgfSBmcm9tICcuL2RvbWFpbi1uYW1lJztcbmltcG9ydCB7IElSZXN0QXBpLCBSZXN0QXBpIH0gZnJvbSAnLi9yZXN0YXBpJztcbmltcG9ydCB7IFN0YWdlIH0gZnJvbSAnLi9zdGFnZSc7XG5leHBvcnQgaW50ZXJmYWNlIEJhc2VQYXRoTWFwcGluZ09wdGlvbnMge1xuICAgIC8qKlxuICAgICAqIFRoZSBiYXNlIHBhdGggbmFtZSB0aGF0IGNhbGxlcnMgb2YgdGhlIEFQSSBtdXN0IHByb3ZpZGUgaW4gdGhlIFVSTCBhZnRlclxuICAgICAqIHRoZSBkb21haW4gbmFtZSAoZS5nLiBgZXhhbXBsZS5jb20vYmFzZS1wYXRoYCkuIElmIHlvdSBzcGVjaWZ5IHRoaXNcbiAgICAgKiBwcm9wZXJ0eSwgaXQgY2FuJ3QgYmUgYW4gZW1wdHkgc3RyaW5nLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBtYXAgcmVxdWVzdHMgZnJvbSB0aGUgZG9tYWluIHJvb3QgKGUuZy4gYGV4YW1wbGUuY29tYCkuIElmIHRoaXNcbiAgICAgKiBpcyB1bmRlZmluZWQsIG5vIGFkZGl0aW9uYWwgbWFwcGluZ3Mgd2lsbCBiZSBhbGxvd2VkIG9uIHRoaXMgZG9tYWluIG5hbWUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYmFzZVBhdGg/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIERlcGxveW1lbnQgc3RhZ2Ugb2YgQVBJXG4gICAgICogW2Rpc2FibGUtYXdzbGludDpyZWYtdmlhLWludGVyZmFjZV1cbiAgICAgKiBAZGVmYXVsdCAtIG1hcCB0byBkZXBsb3ltZW50U3RhZ2Ugb2YgcmVzdEFwaSBvdGhlcndpc2Ugc3RhZ2UgbmVlZHMgdG8gcGFzcyBpbiBVUkxcbiAgICAgKi9cbiAgICByZWFkb25seSBzdGFnZT86IFN0YWdlO1xufVxuZXhwb3J0IGludGVyZmFjZSBCYXNlUGF0aE1hcHBpbmdQcm9wcyBleHRlbmRzIEJhc2VQYXRoTWFwcGluZ09wdGlvbnMge1xuICAgIC8qKlxuICAgICAqIFRoZSBEb21haW5OYW1lIHRvIGFzc29jaWF0ZSB3aXRoIHRoaXMgYmFzZSBwYXRoIG1hcHBpbmcuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZG9tYWluTmFtZTogSURvbWFpbk5hbWU7XG4gICAgLyoqXG4gICAgICogVGhlIFJlc3RBcGkgcmVzb3VyY2UgdG8gdGFyZ2V0LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlc3RBcGk6IElSZXN0QXBpO1xufVxuLyoqXG4gKiBUaGlzIHJlc291cmNlIGNyZWF0ZXMgYSBiYXNlIHBhdGggdGhhdCBjbGllbnRzIHdobyBjYWxsIHlvdXIgQVBJIG11c3QgdXNlIGluXG4gKiB0aGUgaW52b2NhdGlvbiBVUkwuXG4gKlxuICogVW5sZXNzIHlvdSdyZSBpbXBvcnRpbmcgYSBkb21haW4gd2l0aCBgRG9tYWluTmFtZS5mcm9tRG9tYWluTmFtZUF0dHJpYnV0ZXMoKWAsXG4gKiB5b3UgY2FuIHVzZSBgRG9tYWluTmFtZS5hZGRCYXNlUGF0aE1hcHBpbmcoKWAgdG8gZGVmaW5lIG1hcHBpbmdzLlxuICovXG5leHBvcnQgY2xhc3MgQmFzZVBhdGhNYXBwaW5nIGV4dGVuZHMgUmVzb3VyY2Uge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBCYXNlUGF0aE1hcHBpbmdQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICBpZiAocHJvcHMuYmFzZVBhdGggJiYgIVRva2VuLmlzVW5yZXNvbHZlZChwcm9wcy5iYXNlUGF0aCkpIHtcbiAgICAgICAgICAgIGlmICghcHJvcHMuYmFzZVBhdGgubWF0Y2goL15bYS16MC05JF8uKyEqJygpLV0rJC8pKSB7XG4gICAgICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBBIGJhc2UgcGF0aCBtYXkgb25seSBjb250YWluIGxldHRlcnMsIG51bWJlcnMsIGFuZCBvbmUgb2YgXCIkLV8uKyEqJygpXCIsIHJlY2VpdmVkOiAke3Byb3BzLmJhc2VQYXRofWApO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIC8vIGlmIHJlc3RBcGkgaXMgYW4gb3duZWQgQVBJIGFuZCBpdCBoYXMgYSBkZXBsb3ltZW50IHN0YWdlLCBtYXAgYWxsIHJlcXVlc3RzXG4gICAgICAgIC8vIHRvIHRoYXQgc3RhZ2UuIG90aGVyd2lzZSwgdGhlIHN0YWdlIHdpbGwgaGF2ZSB0byBiZSBzcGVjaWZpZWQgaW4gdGhlIFVSTC5cbiAgICAgICAgY29uc3Qgc3RhZ2UgPSBwcm9wcy5zdGFnZSA/PyAocHJvcHMucmVzdEFwaSBpbnN0YW5jZW9mIFJlc3RBcGlcbiAgICAgICAgICAgID8gcHJvcHMucmVzdEFwaS5kZXBsb3ltZW50U3RhZ2VcbiAgICAgICAgICAgIDogdW5kZWZpbmVkKTtcbiAgICAgICAgbmV3IENmbkJhc2VQYXRoTWFwcGluZyh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICAgICAgICBiYXNlUGF0aDogcHJvcHMuYmFzZVBhdGgsXG4gICAgICAgICAgICBkb21haW5OYW1lOiBwcm9wcy5kb21haW5OYW1lLmRvbWFpbk5hbWUsXG4gICAgICAgICAgICByZXN0QXBpSWQ6IHByb3BzLnJlc3RBcGkucmVzdEFwaUlkLFxuICAgICAgICAgICAgc3RhZ2U6IHN0YWdlICYmIHN0YWdlLnN0YWdlTmFtZSxcbiAgICAgICAgfSk7XG4gICAgfVxufVxuIl19