"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * GitHub source code provider
 */
class GitHubSourceCodeProvider {
    constructor(props) {
        this.props = props;
    }
    bind(_app) {
        return {
            repository: `https://github.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
exports.GitHubSourceCodeProvider = GitHubSourceCodeProvider;
/**
 * CodeCommit source code provider
 */
class CodeCommitSourceCodeProvider {
    constructor(props) {
        this.props = props;
    }
    bind(app) {
        this.props.repository.grantPull(app);
        return {
            repository: this.props.repository.repositoryCloneUrlHttp,
        };
    }
}
exports.CodeCommitSourceCodeProvider = CodeCommitSourceCodeProvider;
//# sourceMappingURL=data:application/json;base64,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