"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const amplify_generated_1 = require("./amplify.generated");
const utils_1 = require("./utils");
/**
 * An Amplify Console branch
 */
class Branch extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.environmentVariables = props.environmentVariables || {};
        const branchName = props.branchName || id;
        const branch = new amplify_generated_1.CfnBranch(this, 'Resource', {
            appId: props.app.appId,
            basicAuthConfig: props.basicAuth && props.basicAuth.bind(this, `${branchName}BasicAuth`),
            branchName,
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            description: props.description,
            enableAutoBuild: props.autoBuild === undefined ? true : props.autoBuild,
            enablePullRequestPreview: props.pullRequestPreview === undefined ? true : props.pullRequestPreview,
            environmentVariables: core_1.Lazy.anyValue({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            pullRequestEnvironmentName: props.pullRequestEnvironmentName,
            stage: props.stage,
        });
        this.arn = branch.attrArn;
        this.branchName = branch.attrBranchName;
    }
    /**
     * Import an existing branch
     */
    static fromBranchName(scope, id, branchName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.branchName = branchName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds an environment variable to this branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
}
exports.Branch = Branch;
//# sourceMappingURL=data:application/json;base64,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