# Scikit-rt

[![License](https://img.shields.io/github/license/scikit-rt/scikit-rt)](https://github.com/scikit-rt/scikit-rt/blob/master/LICENSE)

[![GitHub Actions](https://github.com/scikit-rt/scikit-rt/actions/workflows/docker.yml/badge.svg?branch=master)](https://github.com/scikit-rt/scikit-rt/actions/workflows/docker.yml?query=branch%3Amaster)
[![GitHub Actions](https://github.com/scikit-rt/scikit-rt/actions/workflows/pypi.yml/badge.svg?branch=master)](https://github.com/scikit-rt/scikit-rt/actions/workflows/pypi.yml?query=branch%3Amaster)
[![GitHub Actions](https://github.com/scikit-rt/scikit-rt/actions/workflows/sphinx.yml/badge.svg?branch=master)](https://github.com/scikit-rt/scikit-rt/actions/workflows/sphinx.yml?query=branch%3Amaster)
[![GitHub Actions](https://github.com/scikit-rt/scikit-rt/actions/workflows/macos.yml/badge.svg?branch=master)](https://github.com/scikit-rt/scikit-rt/actions/workflows/macos.yml?query=branch%3Amaster)
[![GitHub Actions](https://github.com/scikit-rt/scikit-rt/actions/workflows/windows.yml/badge.svg?branch=master)](https://github.com/scikit-rt/scikit-rt/actions/workflows/windows.yml?query=branch%3Amaster)

Scikit-rt provides tools for loading, plotting, and analysing
radiotherapy data in [DICOM](https://www.dicomstandard.org/) and
[NIfTI](https://nifti.nimh.nih.gov/) formats.  It includes
image registration via [elastix](https://elastix.lumc.nl/)
and [NiftyReg](http://cmictig.cs.ucl.ac.uk/wiki/index.php/NiftyReg),
single- and multi-atlas segmentation, and region-of-interest (ROI)
comparisons.

Documentation: [https://scikit-rt.github.io/scikit-rt/](https://scikit-rt.github.io/scikit-rt/)  
Code repository: [https://github.com/scikit-rt/scikit-rt/](https://github.com/scikit-rt/scikit-rt/)  
PyPI project page: [https://pypi.org/project/scikit-rt/](https://pypi.org/project/scikit-rt/)  

This work was supported by Cancer Research UK RadNet Cambridge [C17918/A28870].

<img src="docs/images/Radnet Cambridge.png" alt="RadNet logo" height="150"/>

## Help topics

1. [Documentation and support](docs/markdown/support.md)
2. [Installation](docs/markdown/installation.md)
3. [Scikit-rt by examples](docs/markdown/examples.md)
4. [Usage and data model](docs/markdown/usage.md)
5. [Images](docs/markdown/images.md)
6. [Regions of interest and structure sets](docs/markdown/structures.md)
7. [Patients and studies](docs/markdown/patients_and_studies.md)
8. [Synthetic data](docs/markdown/simulation.md)
9. [Image registration](docs/markdown/registration.md)
10. [Keyboard shortcuts for pop-out interactive viewer](docs/markdown/keyboard_shortcuts.md)
11. [Scikit-rt with Docker](docs/markdown/docker.md)
12. [Scikit-rt with Kubernetes](docs/markdown/kubernetes.md)
13. [Legacy code](docs/markdown/legacy.md)
