from event_synchronization.synchronization_base import get_optimal_matching_per_location, LocationType, Matching
from event_synchronization.PiecewiseCteFct1D import PiecewiseCteFct1D, Segment
from typing import Tuple, List
import logging

logger=logging.getLogger(__name__)

def matching_up_to_translation(
    l1: List[float], 
    l2: List[float], 
    max_shift: float
) -> Matching:
    
    res= get_optimal_matching_per_location(
        l1, l2, PiecewiseCteFct1D, 
        lambda t1, t2: Segment(t1-t2-max_shift, t1-t2+max_shift))
    
    # print(res)
    loc, m, a = max(res, key=lambda t: t[1].size())
    if a:
        logger.warning("Computed matching may not be optimal")
    logger.info("Location for current matching is {}".format(loc))
    return m

# if __name__ == "__main__":
#     import beautifullogger
#     beautifullogger.setup()
    

#     l1 = [3.058, 4.058, 14.48, 15.48, 32.247, 33.247, 53.783, 54.783, 95.777, 96.777, 113.351, 114.351, 131.307, 132.307, 149.712, 150.712, 174.654, 175.654, 193.228, 194.228, 223.002, 224.002, 263.901, 264.901, 285.729, 286.729, 329.778, 330.778, 378.991, 379.991, 405.068, 406.068, 422.387, 423.387, 452.655, 453.655, 472.619, 473.619, 490.362, 491.362, 508.808, 509.808, 527.054, 528.054, 580.503, 581.503, 611.917, 612.917, 707.687, 708.687, 766.95, 767.95, 787.125, 788.125, 805.94, 806.94, 883.316, 884.316, 910.667, 911.667, 928.021, 929.021, 1046.101, 1047.101, 1055.209, 1056.209, 1094.361, 1095.361, 1106.746, 1107.746, 1141.447, 1142.447, 1161.955, 1162.955, 1178.854, 1179.854, 1206.576, 1207.576, 1237.81, 1238.81, 1262.615, 1263.615, 1283.218, 1284.218, 1361.593, 1362.593, 1383.929, 1384.929, 1921.851, 1922.851, 1939.572, 1940.572, 1958.039, 1959.039, 1978.574, 1979.574, 2030.576, 2031.576, 2062.496, 2063.496, 2081.376, 2082.376, 2109.098, 2110.098, 2129.254, 2130.254, 2146.768, 2147.768, 2172.478, 2173.478, 2192.296, 2193.296, 2265.847, 2266.847, 2291.708, 2292.708, 2318.051, 2319.051, 2341.505, 2342.505, 2388.112, 2389.112, 2408.078, 2409.078, 2431.181, 2432.181, 2452.123, 2453.123, 2469.385, 2470.385, 2496.271, 2497.271]
#     l2 = [476.13301, 477.13301, 487.5553549999999, 488.5553549999999, 505.3227749999999, 506.3227749999999, 526.8594149999999, 527.8594149999999, 568.8548049999999, 569.8548049999999, 586.4289399999999, 587.4289399999999, 604.3856349999999, 605.3856349999999, 622.7910299999999, 623.7910299999999, 647.7338699999999, 648.7338699999999, 666.308195, 667.308195, 696.0828699999998, 697.0828699999998, 736.983585, 737.983585, 758.8112149999998, 759.8112149999998, 802.8621949999999, 803.8621949999999, 852.0764449999999, 853.0764449999999, 878.1537849999999, 879.1537849999999, 895.4733149999998, 896.4733149999998, 925.7418799999998, 926.7418799999998, 945.70712, 946.70712, 963.45074, 964.45074, 981.8964999999998, 982.8964999999998, 1000.14392, 1001.14392, 1053.5937599999995, 1054.5937599999995, 1085.0092899999995, 1086.0092899999995, 1180.78111, 1181.78111, 1240.04615, 1241.04615, 1260.2222399999998, 1261.2222399999998, 1279.0378049999997, 1280.0378049999997, 1356.4157749999997, 1357.4157749999997, 1383.76753, 1384.76753, 1401.1220999999998, 1402.1220999999998, 1519.2051599999998, 1520.2051599999998, 1528.3136699999998, 1529.3136699999998, 1567.4666449999995, 1568.4666449999995, 1579.8522149999997, 1580.8522149999997, 1614.5539199999998, 1615.5539199999998, 1635.0626349999998, 1636.0626349999998, 1651.9623299999998, 1652.9623299999998, 1679.6848099999995, 1680.6848099999995, 1710.9196699999998, 1711.9196699999998, 1735.7257549999997, 1736.7257549999997, 1756.3291649999996, 1757.3291649999996, 1834.706275, 1835.706275, 1857.04276, 1858.04276, 2394.979835, 2395.979835, 2412.701695, 2413.701695, 2431.16926, 2432.16926, 2451.7046599999994, 2452.7046599999994, 2503.707505, 2504.707505, 2535.62923, 2536.62923, 2554.50898, 2555.50898, 2582.232175, 2583.232175, 2602.3888299999994, 2603.3888299999994, 2619.9036399999995, 2620.9036399999995, 2645.61448, 2646.61448, 2665.432, 2666.432, 2738.9852799999994, 2739.9852799999994, 2764.847005, 2765.847005, 2791.1907449999994, 2792.1907449999994, 2814.646095, 2815.646095, 2861.2544849999995, 2862.2544849999995, 2881.220275, 2882.220275, 2904.3245849999994, 2905.3245849999994, 2925.267075, 2926.267075, 2942.5297199999995, 2943.5297199999995]
#     l2_used = l2[0:65]
#     l1_used = l1[0:66]
#     profile=False
#     if profile:
#         import cProfile
#         import pstats
#         cProfile.run("matching_up_to_translation(l1_used, l2_used, 0.1)", 'restats')
#         p = pstats.Stats('restats')
#         p.sort_stats(pstats.SortKey.TIME).print_stats(30)
#     else:
#         res = matching_up_to_translation(l1_used, l2_used, 0.1)
    