from collective.solr.exceptions import SolrConnectionException
from collective.solr.interfaces import ISolrConnectionManager
from Products.Five.browser import BrowserView
from zope.component import getUtility
import json
import urllib


class SuggestView(BrowserView):
    """Get autocomplete suggestions using solr's suggester component."""

    def __call__(self):
        suggestions = []
        term = self.request.form.get('term', '')
        if not term:
            return json.dumps(suggestions)

        manager = getUtility(ISolrConnectionManager)
        connection = manager.getConnection()

        if connection is None:
            return json.dumps(suggestions)

        params = {}
        params['q'] = term
        params['wt'] = 'json'

        params = urllib.urlencode(params, doseq=True)

        try:
            response = connection.doPost(
                connection.solrBase + '/suggest?' + params, '', {})

        except SolrConnectionException, e:
            return json.dumps([])

        results = json.loads(response.read())
        spellcheck = results.get('spellcheck', None)
        if not spellcheck:
            return json.dumps(suggestions)
        spellcheck_suggestions = spellcheck.get('suggestions', None)
        if not spellcheck_suggestions:
            return json.dumps(suggestions)

        for suggestion in spellcheck_suggestions[1]['suggestion']:
            suggestions.append(dict(label=suggestion, value=suggestion))

        return json.dumps(suggestions)
