"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostedRotationType = exports.HostedRotation = exports.RotationSchedule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const kms = require("@aws-cdk/aws-kms");
const core_1 = require("@aws-cdk/core");
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * A rotation schedule.
 *
 * @stability stable
 */
class RotationSchedule extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _d, _e, _f;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_RotationScheduleProps(props);
        if ((!props.rotationLambda && !props.hostedRotation) || (props.rotationLambda && props.hostedRotation)) {
            throw new Error('One of `rotationLambda` or `hostedRotation` must be specified.');
        }
        if ((_d = props.rotationLambda) === null || _d === void 0 ? void 0 : _d.permissionsNode.defaultChild) {
            if (props.secret.encryptionKey) {
                props.secret.encryptionKey.grantEncryptDecrypt(new kms.ViaServicePrincipal(`secretsmanager.${core_1.Stack.of(this).region}.amazonaws.com`, props.rotationLambda.grantPrincipal));
            }
            props.rotationLambda.grantInvoke(new iam.ServicePrincipal('secretsmanager.amazonaws.com'));
            props.rotationLambda.addToRolePolicy(new iam.PolicyStatement({
                actions: [
                    'secretsmanager:DescribeSecret',
                    'secretsmanager:GetSecretValue',
                    'secretsmanager:PutSecretValue',
                    'secretsmanager:UpdateSecretVersionStage',
                ],
                resources: [props.secret.secretArn],
            }));
            props.rotationLambda.addToRolePolicy(new iam.PolicyStatement({
                actions: [
                    'secretsmanager:GetRandomPassword',
                ],
                resources: ['*'],
            }));
        }
        new secretsmanager_generated_1.CfnRotationSchedule(this, 'Resource', {
            secretId: props.secret.secretArn,
            rotationLambdaArn: (_e = props.rotationLambda) === null || _e === void 0 ? void 0 : _e.functionArn,
            hostedRotationLambda: (_f = props.hostedRotation) === null || _f === void 0 ? void 0 : _f.bind(props.secret, this),
            rotationRules: {
                automaticallyAfterDays: props.automaticallyAfter && props.automaticallyAfter.toDays() || 30,
            },
        });
        // Prevent secrets deletions when rotation is in place
        props.secret.denyAccountRootDelete();
    }
}
exports.RotationSchedule = RotationSchedule;
_a = JSII_RTTI_SYMBOL_1;
RotationSchedule[_a] = { fqn: "@aws-cdk/aws-secretsmanager.RotationSchedule", version: "1.138.0" };
/**
 * A hosted rotation.
 *
 * @stability stable
 */
class HostedRotation {
    constructor(type, props, masterSecret) {
        this.type = type;
        this.props = props;
        this.masterSecret = masterSecret;
        if (type.isMultiUser && !masterSecret) {
            throw new Error('The `masterSecret` must be specified when using the multi user scheme.');
        }
    }
    /**
     * MySQL Single User.
     *
     * @stability stable
     */
    static mysqlSingleUser(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.MYSQL_SINGLE_USER, options);
    }
    /**
     * MySQL Multi User.
     *
     * @stability stable
     */
    static mysqlMultiUser(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.MYSQL_MULTI_USER, options, options.masterSecret);
    }
    /**
     * PostgreSQL Single User.
     *
     * @stability stable
     */
    static postgreSqlSingleUser(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.POSTGRESQL_SINGLE_USER, options);
    }
    /**
     * PostgreSQL Multi User.
     *
     * @stability stable
     */
    static postgreSqlMultiUser(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.POSTGRESQL_MULTI_USER, options, options.masterSecret);
    }
    /**
     * Oracle Single User.
     *
     * @stability stable
     */
    static oracleSingleUser(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.ORACLE_SINGLE_USER, options);
    }
    /**
     * Oracle Multi User.
     *
     * @stability stable
     */
    static oracleMultiUser(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.ORACLE_MULTI_USER, options, options.masterSecret);
    }
    /**
     * MariaDB Single User.
     *
     * @stability stable
     */
    static mariaDbSingleUser(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.MARIADB_SINGLE_USER, options);
    }
    /**
     * MariaDB Multi User.
     *
     * @stability stable
     */
    static mariaDbMultiUser(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.MARIADB_MULTI_USER, options, options.masterSecret);
    }
    /**
     * SQL Server Single User.
     *
     * @stability stable
     */
    static sqlServerSingleUser(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.SQLSERVER_SINGLE_USER, options);
    }
    /**
     * SQL Server Multi User.
     *
     * @stability stable
     */
    static sqlServerMultiUser(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.SQLSERVER_MULTI_USER, options, options.masterSecret);
    }
    /**
     * Redshift Single User.
     *
     * @stability stable
     */
    static redshiftSingleUser(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.REDSHIFT_SINGLE_USER, options);
    }
    /**
     * Redshift Multi User.
     *
     * @stability stable
     */
    static redshiftMultiUser(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.REDSHIFT_MULTI_USER, options, options.masterSecret);
    }
    /**
     * MongoDB Single User.
     *
     * @stability stable
     */
    static mongoDbSingleUser(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.MONGODB_SINGLE_USER, options);
    }
    /**
     * MongoDB Multi User.
     *
     * @stability stable
     */
    static mongoDbMultiUser(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        return new HostedRotation(HostedRotationType.MONGODB_MULTI_USER, options, options.masterSecret);
    }
    /**
     * Binds this hosted rotation to a secret.
     *
     * @stability stable
     */
    bind(secret, scope) {
        var _d, _e, _f, _g, _h, _j, _k;
        jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_ISecret(secret);
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html
        core_1.Stack.of(scope).addTransform('AWS::SecretsManager-2020-07-23');
        if (!this.props.vpc && this.props.securityGroups) {
            throw new Error('`vpc` must be specified when specifying `securityGroups`.');
        }
        if (this.props.vpc) {
            this._connections = new ec2.Connections({
                securityGroups: this.props.securityGroups || [new ec2.SecurityGroup(scope, 'SecurityGroup', {
                        vpc: this.props.vpc,
                    })],
            });
        }
        // Prevent master secret deletion when rotation is in place
        if (this.masterSecret) {
            this.masterSecret.denyAccountRootDelete();
        }
        return {
            rotationType: this.type.name,
            kmsKeyArn: (_d = secret.encryptionKey) === null || _d === void 0 ? void 0 : _d.keyArn,
            masterSecretArn: (_e = this.masterSecret) === null || _e === void 0 ? void 0 : _e.secretArn,
            masterSecretKmsKeyArn: (_g = (_f = this.masterSecret) === null || _f === void 0 ? void 0 : _f.encryptionKey) === null || _g === void 0 ? void 0 : _g.keyArn,
            rotationLambdaName: this.props.functionName,
            vpcSecurityGroupIds: (_j = (_h = this._connections) === null || _h === void 0 ? void 0 : _h.securityGroups) === null || _j === void 0 ? void 0 : _j.map(s => s.securityGroupId).join(','),
            vpcSubnetIds: (_k = this.props.vpc) === null || _k === void 0 ? void 0 : _k.selectSubnets(this.props.vpcSubnets).subnetIds.join(','),
        };
    }
    /**
     * Security group connections for this hosted rotation.
     *
     * @stability stable
     */
    get connections() {
        if (!this.props.vpc) {
            throw new Error('Cannot use connections for a hosted rotation that is not deployed in a VPC');
        }
        // If we are in a vpc and bind() has been called _connections should be defined
        if (!this._connections) {
            throw new Error('Cannot use connections for a hosted rotation that has not been bound to a secret');
        }
        return this._connections;
    }
}
exports.HostedRotation = HostedRotation;
_b = JSII_RTTI_SYMBOL_1;
HostedRotation[_b] = { fqn: "@aws-cdk/aws-secretsmanager.HostedRotation", version: "1.138.0" };
/**
 * Hosted rotation type.
 *
 * @stability stable
 */
class HostedRotationType {
    /**
     * @param name The type of rotation
     * @param isMultiUser Whether the rotation uses the mutli user scheme
     */
    constructor(name, isMultiUser) {
        this.name = name;
        this.isMultiUser = isMultiUser;
    }
}
exports.HostedRotationType = HostedRotationType;
_c = JSII_RTTI_SYMBOL_1;
HostedRotationType[_c] = { fqn: "@aws-cdk/aws-secretsmanager.HostedRotationType", version: "1.138.0" };
/**
 * MySQL Single User.
 *
 * @stability stable
 */
HostedRotationType.MYSQL_SINGLE_USER = new HostedRotationType('MySQLSingleUser');
/**
 * MySQL Multi User.
 *
 * @stability stable
 */
HostedRotationType.MYSQL_MULTI_USER = new HostedRotationType('MySQLMultiUser', true);
/**
 * PostgreSQL Single User.
 *
 * @stability stable
 */
HostedRotationType.POSTGRESQL_SINGLE_USER = new HostedRotationType('PostgreSQLSingleUser');
/**
 * PostgreSQL Multi User.
 *
 * @stability stable
 */
HostedRotationType.POSTGRESQL_MULTI_USER = new HostedRotationType('PostgreSQLMultiUser', true);
/**
 * Oracle Single User.
 *
 * @stability stable
 */
HostedRotationType.ORACLE_SINGLE_USER = new HostedRotationType('OracleSingleUser');
/**
 * Oracle Multi User.
 *
 * @stability stable
 */
HostedRotationType.ORACLE_MULTI_USER = new HostedRotationType('OracleMultiUser', true);
/**
 * MariaDB Single User.
 *
 * @stability stable
 */
HostedRotationType.MARIADB_SINGLE_USER = new HostedRotationType('MariaDBSingleUser');
/**
 * MariaDB Multi User.
 *
 * @stability stable
 */
HostedRotationType.MARIADB_MULTI_USER = new HostedRotationType('MariaDBMultiUser', true);
/**
 * SQL Server Single User.
 *
 * @stability stable
 */
HostedRotationType.SQLSERVER_SINGLE_USER = new HostedRotationType('SQLServerSingleUser');
/**
 * SQL Server Multi User.
 *
 * @stability stable
 */
HostedRotationType.SQLSERVER_MULTI_USER = new HostedRotationType('SQLServerMultiUser', true);
/**
 * Redshift Single User.
 *
 * @stability stable
 */
HostedRotationType.REDSHIFT_SINGLE_USER = new HostedRotationType('RedshiftSingleUser');
/**
 * Redshift Multi User.
 *
 * @stability stable
 */
HostedRotationType.REDSHIFT_MULTI_USER = new HostedRotationType('RedshiftMultiUser', true);
/**
 * MongoDB Single User.
 *
 * @stability stable
 */
HostedRotationType.MONGODB_SINGLE_USER = new HostedRotationType('MongoDBSingleUser');
/**
 * MongoDB Multi User.
 *
 * @stability stable
 */
HostedRotationType.MONGODB_MULTI_USER = new HostedRotationType('MongoDBMultiUser', true);
//# sourceMappingURL=data:application/json;base64,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