/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.util;

import eu.quanticol.moonlight.core.base.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Stopwatch {
    private static final Map<UUID, Pair<Long, Long>> sessions = new HashMap<UUID, Pair<Long, Long>>();
    private final UUID sessionId;

    private Stopwatch(UUID id) {
        this.sessionId = id;
    }

    public static Stopwatch start() {
        UUID id = UUID.randomUUID();
        Long start = System.currentTimeMillis();
        sessions.put(id, new Pair<Long, Object>(start, null));
        return new Stopwatch(id);
    }

    public long stop() {
        Long start = sessions.remove(this.sessionId).getFirst();
        Long end = System.currentTimeMillis();
        sessions.put(this.sessionId, new Pair<Long, Long>(start, end));
        return end - start;
    }

    public static long getDuration(UUID sessionId) {
        Pair<Long, Long> session = sessions.get(sessionId);
        if (session != null && session.getSecond() != null) {
            return session.getSecond() - session.getFirst();
        }
        throw new UnsupportedOperationException("The requested session never started or never ended");
    }

    public long getDuration() {
        Pair<Long, Long> session = sessions.get(this.sessionId);
        if (session != null && session.getSecond() != null) {
            return session.getSecond() - session.getFirst();
        }
        throw new UnsupportedOperationException("The requested session never ended");
    }

    public static Map<UUID, Pair<Long, Long>> getSessions() {
        return new HashMap<UUID, Pair<Long, Long>>(sessions);
    }
}

