/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.signal;

import eu.quanticol.moonlight.core.signal.Sample;
import eu.quanticol.moonlight.online.signal.ChainIterator;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class TimeChain<T extends Comparable<T>, V>
implements Iterable<Sample<T, V>> {
    private final List<Sample<T, V>> segments;
    private final T end;
    private static final String MONOTONICITY = "Violating monotonicity: The chain must be in monotonic time order";
    private static final String ENDING_COND = "Violating ending condition: The chain must either end after the last segment or after the previous ending";

    public TimeChain(@NotNull T end) {
        this.end = end;
        this.segments = new ArrayList<Sample<T, V>>();
    }

    public TimeChain(@NotNull Sample<T, V> element, @NotNull T end) {
        if (end.compareTo(element.getStart()) < 0) {
            throw new IllegalArgumentException(ENDING_COND);
        }
        this.end = end;
        this.segments = new ArrayList<Sample<T, V>>();
        this.segments.add(element);
    }

    public TimeChain(@NotNull List<Sample<T, V>> segments, @NotNull T end) {
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("Invalid Segment list");
        }
        if (end.compareTo(segments.get(segments.size() - 1).getStart()) < 0) {
            throw new IllegalArgumentException(ENDING_COND);
        }
        this.end = end;
        this.segments = new ArrayList<Sample<T, V>>(segments);
    }

    public boolean add(Sample<T, V> e) {
        if (this.end.compareTo(e.getStart()) > 0) {
            this.checkMonotonicity(e.getStart());
            return this.segments.add(e);
        }
        throw new IllegalArgumentException(ENDING_COND);
    }

    private void checkMonotonicity(T t) {
        if (!this.segments.isEmpty() && this.segments.get(this.segments.size() - 1).getStart().compareTo(t) > 0) {
            throw new IllegalArgumentException(MONOTONICITY);
        }
    }

    public TimeChain<T, V> copy() {
        return new TimeChain<T, V>(this.segments, this.end);
    }

    public TimeChain<T, V> subChain(int from, int to, T end) {
        List<Sample<T, V>> newList = this.segments.subList(from, to);
        return new TimeChain<T, V>(newList, end);
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public void clear() {
        this.segments.clear();
    }

    public Sample<T, V> getLast() {
        return this.segments.get(this.segments.size() - 1);
    }

    public ChainIterator<Sample<T, V>> chainIterator() {
        return this.chainIterator(0);
    }

    public ChainIterator<Sample<T, V>> chainIterator(int index) {
        if (index < 0 || index > this.segments.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ChainIterator<Sample<T, V>>(this.segments, index);
    }

    public List<Update<T, V>> toUpdates() {
        ArrayList<Update<T, V>> updates = new ArrayList<Update<T, V>>(this.segments.size());
        for (int i = 0; i < this.segments.size(); ++i) {
            T uEnd = this.end;
            if (i != this.segments.size() - 1) {
                uEnd = this.segments.get(i + 1).getStart();
            }
            Update<T, V> u = new Update<T, V>(this.segments.get(i).getStart(), uEnd, this.segments.get(i).getValue());
            updates.add(u);
        }
        return updates;
    }

    @Override
    @NotNull
    public Iterator<Sample<T, V>> iterator() {
        return this.segments.iterator();
    }

    @Override
    public void forEach(Consumer<? super Sample<T, V>> action) {
        this.segments.forEach(action);
    }

    @Override
    public Spliterator<Sample<T, V>> spliterator() {
        return this.segments.spliterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeChain)) {
            return false;
        }
        TimeChain timeChain = (TimeChain)o;
        return this.segments.equals(timeChain.segments) && this.end.equals(timeChain.end);
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.end);
    }

    public Stream<Sample<T, V>> stream() {
        return this.segments.stream();
    }

    public T getEnd() {
        return this.end;
    }

    public List<Sample<T, V>> toList() {
        return this.segments;
    }

    public int size() {
        return this.segments.size();
    }

    public Sample<T, V> getFirst() {
        return this.segments.get(0);
    }

    public T getStart() {
        return this.getFirst().getStart();
    }

    public Sample<T, V> get(int index) {
        return this.segments.get(index);
    }

    public String toString() {
        return "TimeChain{segments=" + this.segments + ", end=" + this.end + "}";
    }
}

