/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.signal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.SpaceTimeSignal;
import eu.quanticol.moonlight.online.algorithms.Signals;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.TimeSegment;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class OnlineSpaceTimeSignal<D extends Comparable<D>>
implements SpaceTimeSignal<Double, Box<D>> {
    private final TimeChain<Double, List<Box<D>>> segments;
    private final int size;

    public OnlineSpaceTimeSignal(int locations, SignalDomain<D> domain) {
        List any = IntStream.range(0, locations).boxed().map(i -> new Box<Comparable>((Comparable)domain.min(), (Comparable)domain.max())).collect(Collectors.toList());
        this.segments = new TimeChain(new TimeSegment(0.0, any), Double.valueOf(Double.POSITIVE_INFINITY));
        this.size = locations;
    }

    @Override
    public boolean refine(Update<Double, List<Box<D>>> u) {
        return Signals.refine(this.segments, u, (v, vNew) -> IntStream.range(0, this.size).filter(i -> ((Box)v.get(i)).contains((Box)vNew.get(i))).count() != 0L);
    }

    @Override
    public boolean refine(TimeChain<Double, List<Box<D>>> updates) {
        return Signals.refineChain(this.segments, updates, (v, vNew) -> IntStream.range(0, this.size).filter(i -> ((Box)v.get(i)).contains((Box)vNew.get(i))).count() != 0L);
    }

    @Override
    public TimeChain<Double, List<Box<D>>> getSegments() {
        return this.segments;
    }

    @Override
    public TimeChain<Double, List<Box<D>>> select(Double from, Double to) {
        return Signals.select(this.segments, from, to);
    }

    @Override
    public int getSize() {
        return this.size;
    }
}

