/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.monitoring.temporal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.online.algorithms.BooleanOp;
import eu.quanticol.moonlight.online.monitoring.OnlineMonitor;
import eu.quanticol.moonlight.online.signal.OnlineSignal;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

public class BinaryMonitor<V, R extends Comparable<R>>
implements OnlineMonitor<Double, V, Box<R>> {
    private final BinaryOperator<Box<R>> opFunction;
    private final TimeSignal<Double, Box<R>> rho;
    private final OnlineMonitor<Double, V, Box<R>> firstArg;
    private final OnlineMonitor<Double, V, Box<R>> secondArg;

    public BinaryMonitor(OnlineMonitor<Double, V, Box<R>> firstArgument, OnlineMonitor<Double, V, Box<R>> secondArgument, BinaryOperator<Box<R>> binaryOp, SignalDomain<R> interpretation) {
        this.opFunction = binaryOp;
        this.rho = new OnlineSignal<R>(interpretation);
        this.firstArg = firstArgument;
        this.secondArg = secondArgument;
    }

    @Override
    public List<TimeChain<Double, Box<R>>> monitor(Update<Double, V> signalUpdate) {
        ArrayList<TimeChain<Double, Box<R>>> updates = new ArrayList<TimeChain<Double, Box<R>>>();
        List firstArgUps = this.firstArg.monitor(signalUpdate).stream().filter(x -> !x.isEmpty()).collect(Collectors.toList());
        List secondArgUps = this.secondArg.monitor(signalUpdate).stream().filter(x -> !x.isEmpty()).collect(Collectors.toList());
        TimeSignal<Double, Box<R>> s1 = this.firstArg.getResult();
        TimeSignal<Double, Box<R>> s2 = this.secondArg.getResult();
        for (TimeChain argU : firstArgUps) {
            TimeChain<Double, Box<R>> c2 = s2.select((Double)argU.getStart(), (Double)argU.getEnd());
            updates.add(BooleanOp.binarySequence(c2, argU, this.opFunction));
        }
        for (TimeChain argU : secondArgUps) {
            TimeChain<Double, Box<R>> c1 = s1.select((Double)argU.getStart(), (Double)argU.getEnd());
            updates.add(BooleanOp.binarySequence(c1, argU, this.opFunction));
        }
        updates.forEach(this.rho::refine);
        return updates;
    }

    @Override
    public List<TimeChain<Double, Box<R>>> monitor(TimeChain<Double, V> updates) {
        ArrayList<TimeChain<Double, Box<R>>> output = new ArrayList<TimeChain<Double, Box<R>>>();
        List<TimeChain<Double, Box<R>>> firstArgUps = this.firstArg.monitor(updates);
        List<TimeChain<Double, Box<R>>> secondArgUps = this.secondArg.monitor(updates);
        TimeSignal<Double, Box<R>> s1 = this.firstArg.getResult();
        TimeSignal<Double, Box<R>> s2 = this.secondArg.getResult();
        for (TimeChain<Double, Box<R>> argU : firstArgUps) {
            TimeChain<Double, Box<R>> c2 = s2.select(argU.getStart(), argU.getEnd());
            output.add(BooleanOp.binarySequence(c2, argU, this.opFunction));
        }
        for (TimeChain<Double, Box<R>> argU : secondArgUps) {
            TimeChain<Double, Box<R>> c1 = s1.select(argU.getStart(), argU.getEnd());
            output.add(BooleanOp.binarySequence(c1, argU, this.opFunction));
        }
        output.forEach(this.rho::refine);
        return output;
    }

    @Override
    public TimeSignal<Double, Box<R>> getResult() {
        return this.rho;
    }
}

