/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.monitoring.spatialtemporal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.core.signal.SpaceTimeSignal;
import eu.quanticol.moonlight.core.signal.TimeSignal;
import eu.quanticol.moonlight.online.algorithms.TemporalOp;
import eu.quanticol.moonlight.online.monitoring.OnlineMonitor;
import eu.quanticol.moonlight.online.signal.OnlineSpaceTimeSignal;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BinaryOperator;

public class UnaryTimeOpMonitor<V, R extends Comparable<R>>
implements OnlineMonitor<Double, List<V>, List<Box<R>>> {
    private final BinaryOperator<List<Box<R>>> op;
    private final Interval horizon;
    private final SpaceTimeSignal<Double, Box<R>> rho;
    private final OnlineMonitor<Double, List<V>, List<Box<R>>> argumentMonitor;

    public UnaryTimeOpMonitor(OnlineMonitor<Double, List<V>, List<Box<R>>> argument, BinaryOperator<List<Box<R>>> binaryOp, Interval timeHorizon, SignalDomain<R> interpretation, int locations) {
        this.op = binaryOp;
        this.horizon = timeHorizon;
        this.rho = new OnlineSpaceTimeSignal<R>(locations, interpretation);
        this.argumentMonitor = argument;
    }

    @Override
    public List<TimeChain<Double, List<Box<R>>>> monitor(Update<Double, List<V>> signalUpdate) {
        List<TimeChain<Double, List<Box<R>>>> argUpdates = this.argumentMonitor.monitor(signalUpdate);
        TimeChain<Double, List<Box<R>>> s = this.argumentMonitor.getResult().getSegments();
        ArrayList<TimeChain<Double, List<Box<R>>>> updates = new ArrayList<TimeChain<Double, List<Box<R>>>>();
        for (TimeChain<Double, List<Box<R>>> timeChain : argUpdates) {
            updates.addAll(TemporalOp.slidingWindow(s, timeChain, this.horizon, this.op));
        }
        for (TimeChain<Double, List<Box<Object>>> timeChain : updates) {
            this.rho.refine(timeChain);
        }
        return updates;
    }

    @Override
    public List<TimeChain<Double, List<Box<R>>>> monitor(TimeChain<Double, List<V>> updates) {
        List<TimeChain<Double, List<Box<R>>>> argUpdates = this.argumentMonitor.monitor(updates);
        TimeChain<Double, List<Box<R>>> s = this.argumentMonitor.getResult().getSegments();
        ArrayList<TimeChain<Double, List<Box<R>>>> result = new ArrayList<TimeChain<Double, List<Box<R>>>>();
        for (TimeChain<Double, List<Box<R>>> timeChain : argUpdates) {
            result.addAll(TemporalOp.slidingWindow(s, timeChain, this.horizon, this.op));
        }
        for (TimeChain<Double, List<Box<Object>>> timeChain : result) {
            this.rho.refine(timeChain);
        }
        return result;
    }

    @Override
    public TimeSignal<Double, List<Box<R>>> getResult() {
        return this.rho;
    }
}

