/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.monitoring.spatialtemporal;

import eu.quanticol.moonlight.core.base.Box;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.online.algorithms.BooleanOp;
import eu.quanticol.moonlight.online.monitoring.OnlineMonitor;
import eu.quanticol.moonlight.online.signal.OnlineSpaceTimeSignal;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AtomicMonitor<V, R extends Comparable<R>>
implements OnlineMonitor<Double, List<V>, List<Box<R>>> {
    private final Function<List<V>, List<Box<R>>> atomicFunction = x -> x.stream().map(atomicFunction).collect(Collectors.toList());
    private final OnlineSpaceTimeSignal<R> rho;

    public AtomicMonitor(Function<V, Box<R>> atomicFunction, int locations, SignalDomain<R> interpretation) {
        this.rho = new OnlineSpaceTimeSignal<R>(locations, interpretation);
    }

    @Override
    public List<TimeChain<Double, List<Box<R>>>> monitor(Update<Double, List<V>> signalUpdate) {
        TimeChain u = BooleanOp.atomSequence(signalUpdate, this.atomicFunction);
        ArrayList<TimeChain<Double, List<Box<R>>>> updates = new ArrayList<TimeChain<Double, List<Box<R>>>>();
        updates.add(u);
        this.rho.refine(u);
        return updates;
    }

    @Override
    public List<TimeChain<Double, List<Box<R>>>> monitor(TimeChain<Double, List<V>> updates) {
        TimeChain us = BooleanOp.atomSequence(updates, this.atomicFunction);
        ArrayList<TimeChain<Double, List<Box<R>>>> output = new ArrayList<TimeChain<Double, List<Box<R>>>>();
        output.add(us);
        this.rho.refine(us);
        return output;
    }

    public OnlineSpaceTimeSignal<R> getResult() {
        return this.rho;
    }
}

