/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.algorithms;

import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.signal.Sample;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.TimeSegment;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;

public class SlidingWindow<R> {
    private final TimeChain<Double, R> arg;
    private final Interval h;
    private final BinaryOperator<R> op;
    private final double uEnd;
    private final Window<R> w;
    private final TimeChain<Double, R> updates;

    public SlidingWindow(TimeChain<Double, R> argument, Update<Double, R> u, Interval opHorizon, BinaryOperator<R> op) {
        this(argument, u.getStart(), u.getEnd(), opHorizon, op);
    }

    public SlidingWindow(TimeChain<Double, R> argument, TimeChain<Double, R> updates, Interval opHorizon, BinaryOperator<R> op) {
        this(argument, updates.getStart(), updates.getEnd(), opHorizon, op);
    }

    private SlidingWindow(TimeChain<Double, R> argument, double start, double end, Interval opHorizon, BinaryOperator<R> op) {
        this.op = op;
        this.arg = argument;
        this.h = opHorizon;
        this.w = new Window(this.setStartBoundary(start), (Double)opHorizon.getStart());
        this.uEnd = this.setEndBoundary(end);
        this.updates = new TimeChain(this.uEnd);
    }

    private double setStartBoundary(Double start) {
        return start - (Double)this.h.getEnd() > 0.0 ? start - (Double)this.h.getEnd() : 0.0;
    }

    private double setEndBoundary(Double end) {
        return end - (Double)this.h.getStart() > 0.0 ? end - (Double)this.h.getStart() : 0.0;
    }

    public List<TimeChain<Double, R>> runChain() {
        this.processArgument();
        ArrayList<TimeChain<Double, R>> chain = new ArrayList<TimeChain<Double, R>>();
        chain.add(this.updates);
        return chain;
    }

    private void processArgument() {
        if (this.uEnd != 0.0) {
            this.arg.forEach((Consumer<Sample<Double, R>>)((Consumer<Sample>)this::add));
            this.collectUpdates();
        }
    }

    public List<Update<Double, R>> run() {
        this.processArgument();
        return this.updates.toUpdates();
    }

    private void collectUpdates() {
        while (!this.w.isEmpty() && this.w.getStart() < this.uEnd) {
            TimeSegment<Double, R> element = this.w.removeFirst();
            this.addUpdate(element);
        }
    }

    private void add(Sample<Double, R> curr) {
        double newStart = curr.getStart() - (Double)this.h.getStart();
        double newEnd = curr.getStart() - (Double)this.h.getEnd();
        if (!this.w.isEmpty() && curr.getStart() - this.w.getStart() > (Double)this.h.getEnd()) {
            this.slide(newEnd);
        } else if (this.w.getEnd() - (Double)this.h.getStart() < newEnd) {
            this.w.clear();
        }
        this.doAdd(newStart, curr.getValue());
    }

    private void slide(double timeBound) {
        if (!this.w.isEmpty()) {
            TimeSegment<Double, R> first = this.keepSliding(timeBound);
            this.addUpdate(first);
            if (this.w.isEmpty() || this.w.getStart() > timeBound) {
                this.w.addFirst(timeBound, first.getValue());
            }
        }
    }

    private TimeSegment<Double, R> keepSliding(double timeBound) {
        TimeSegment<Double, R> first = this.w.removeFirst();
        while (!this.w.isEmpty() && this.w.getStart() < timeBound) {
            this.addUpdate(first);
            first = this.checkNext(timeBound, first);
        }
        return first;
    }

    private TimeSegment<Double, R> checkNext(double timeBound, TimeSegment<Double, R> prev) {
        TimeSegment<Double, R> next = this.w.removeFirst();
        if (next.getStart() > timeBound) {
            this.w.addFirst(timeBound, prev.getValue());
            this.w.addFirst(next.getStart(), next.getValue());
            return prev;
        }
        return next;
    }

    private void addUpdate(TimeSegment<Double, R> element) {
        if (element.getStart() < this.uEnd) {
            if (element.getStart() < 0.0) {
                element = new TimeSegment<Double, R>(0.0, element.getValue());
            }
            if (!this.updates.isEmpty() && this.updates.getFirst().getStart().equals(element.getStart())) {
                this.updates.clear();
            }
            if (this.updates.isEmpty() || !this.updates.getLast().getValue().equals(element.getValue())) {
                this.updates.add(element);
            }
        }
    }

    private void doAdd(Double t, R v) {
        ArrayDeque tail = new ArrayDeque();
        boolean completed = false;
        while (!this.w.isEmpty() && !completed) {
            TimeSegment<Double, R> last = this.w.removeLast();
            double t2 = last.getStart();
            R v2 = last.getValue();
            Object v3 = this.op.apply(v, v2);
            if (v.equals(v2)) {
                this.w.addLast(t2, v2);
                completed = true;
                continue;
            }
            if (v.equals(v3)) {
                t = t2;
                v = v3;
                continue;
            }
            if (!v2.equals(v3)) {
                tail.addFirst(new TimeSegment<Double, R>(t, v));
                t = t2;
                v = v3;
                continue;
            }
            this.w.addLast(t2, v2);
            this.w.addLast(t, v);
            completed = true;
        }
        if (this.w.isEmpty()) {
            this.w.addLast(t, v);
        }
        this.w.addAll(tail);
    }

    static class Window<V> {
        private final Deque<TimeSegment<Double, V>> deque;
        private double endingTime;
        private final double offset;

        Window(Double startingTime, Double startingOffset) {
            this.endingTime = startingTime;
            this.offset = startingOffset;
            this.deque = new ArrayDeque<TimeSegment<Double, V>>();
        }

        Double getStart() {
            return this.deque.isEmpty() ? this.endingTime : this.deque.getFirst().getStart();
        }

        TimeSegment<Double, V> removeFirst() {
            return this.deque.removeFirst();
        }

        boolean isEmpty() {
            return this.deque.isEmpty();
        }

        void addAll(Collection<TimeSegment<Double, V>> c) {
            this.deque.addAll(c);
        }

        void addLast(double start, V value) {
            TimeSegment<Double, V> e = new TimeSegment<Double, V>(start, value);
            this.deque.addLast(e);
            this.endingTime = start + this.offset;
        }

        void addFirst(double start, V value) {
            this.deque.addFirst(new TimeSegment<Double, V>(start, value));
        }

        TimeSegment<Double, V> removeLast() {
            return this.deque.removeLast();
        }

        void clear() {
            this.deque.clear();
        }

        Double getEnd() {
            return this.endingTime;
        }
    }
}

