/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import eu.quanticol.moonlight.core.formula.Formula;
import eu.quanticol.moonlight.core.formula.FormulaVisitor;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.formula.AtomicFormula;
import eu.quanticol.moonlight.formula.classic.AndFormula;
import eu.quanticol.moonlight.formula.classic.NegationFormula;
import eu.quanticol.moonlight.formula.classic.OrFormula;
import eu.quanticol.moonlight.formula.temporal.EventuallyFormula;
import eu.quanticol.moonlight.formula.temporal.GloballyFormula;
import eu.quanticol.moonlight.formula.temporal.HistoricallyFormula;
import eu.quanticol.moonlight.formula.temporal.OnceFormula;
import eu.quanticol.moonlight.formula.temporal.SinceFormula;
import eu.quanticol.moonlight.formula.temporal.UntilFormula;
import eu.quanticol.moonlight.io.FormulaType;
import java.lang.reflect.Type;

@Deprecated(forRemoval=true)
public class FormulaJSonIO {
    private static final String TYPE_KEY = "formula";
    private static final String ATOMIC_ID = "id";
    private static final String FIRST_ARGUMENT = "first";
    private static final String SECOND_ARGUMENT = "second";
    private static final String ARGUMENT = "arg";
    private static final String LOWER_KEY = "lower";
    private static final String UPPER_KEY = "upper";
    private static final String UNBOUNDED_KEY = "unbound";
    private static FormulaJSonIO jsonIo;
    private GsonBuilder gson = new GsonBuilder();

    private FormulaJSonIO() {
        this.gson.registerTypeHierarchyAdapter(Formula.class, (Object)new FormulaDeserialiser());
        this.gson.registerTypeHierarchyAdapter(Formula.class, (Object)new FormulaSerialiser());
    }

    public static FormulaJSonIO getInstance() {
        if (jsonIo == null) {
            jsonIo = new FormulaJSonIO();
        }
        return jsonIo;
    }

    public String toJson(Formula f1) {
        return this.gson.create().toJson((Object)f1);
    }

    public Formula fromJson(String code) {
        return (Formula)this.gson.create().fromJson(code, Formula.class);
    }

    public class FormulaDeserialiser
    implements JsonDeserializer<Formula> {
        public Formula deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                return this.deserializeFormula(json.getAsJsonObject(), context);
            }
            return null;
        }

        private Formula deserializeFormula(JsonObject json, JsonDeserializationContext context) {
            switch (FormulaType.valueOf(json.get(FormulaJSonIO.TYPE_KEY).getAsString())) {
                case AND: {
                    return new AndFormula(this.deserializeFormula(json.get(FormulaJSonIO.FIRST_ARGUMENT).getAsJsonObject(), context), this.deserializeFormula(json.get(FormulaJSonIO.SECOND_ARGUMENT).getAsJsonObject(), context));
                }
                case ATOMIC: {
                    return new AtomicFormula(json.get(FormulaJSonIO.ATOMIC_ID).getAsString());
                }
                case EVENTUALLY: {
                    return new EventuallyFormula(this.deserializeFormula(json.get(FormulaJSonIO.ARGUMENT).getAsJsonObject(), context), new Interval(json.get(FormulaJSonIO.LOWER_KEY).getAsDouble(), json.get(FormulaJSonIO.UPPER_KEY).getAsDouble()));
                }
                case GLOBALLY: {
                    return new GloballyFormula(this.deserializeFormula(json.get(FormulaJSonIO.ARGUMENT).getAsJsonObject(), context), new Interval(json.get(FormulaJSonIO.LOWER_KEY).getAsDouble(), json.get(FormulaJSonIO.UPPER_KEY).getAsDouble()));
                }
                case NOT: {
                    return new NegationFormula(this.deserializeFormula(json.get(FormulaJSonIO.ARGUMENT).getAsJsonObject(), context));
                }
                case OR: {
                    return new OrFormula(this.deserializeFormula(json.get(FormulaJSonIO.FIRST_ARGUMENT).getAsJsonObject(), context), this.deserializeFormula(json.get(FormulaJSonIO.SECOND_ARGUMENT).getAsJsonObject(), context));
                }
                case UNTIL: {
                    Formula first = this.deserializeFormula(json.get(FormulaJSonIO.FIRST_ARGUMENT).getAsJsonObject(), context);
                    Formula second = this.deserializeFormula(json.get(FormulaJSonIO.SECOND_ARGUMENT).getAsJsonObject(), context);
                    if (json.has(FormulaJSonIO.UNBOUNDED_KEY)) {
                        return new UntilFormula(first, second);
                    }
                    return new UntilFormula(first, second, new Interval(json.get(FormulaJSonIO.LOWER_KEY).getAsDouble(), json.get(FormulaJSonIO.UPPER_KEY).getAsDouble()));
                }
                case SINCE: {
                    Formula first = this.deserializeFormula(json.get(FormulaJSonIO.FIRST_ARGUMENT).getAsJsonObject(), context);
                    Formula second = this.deserializeFormula(json.get(FormulaJSonIO.SECOND_ARGUMENT).getAsJsonObject(), context);
                    if (json.has(FormulaJSonIO.UNBOUNDED_KEY)) {
                        return new SinceFormula(first, second);
                    }
                    return new SinceFormula(first, second, new Interval(json.get(FormulaJSonIO.LOWER_KEY).getAsDouble(), json.get(FormulaJSonIO.UPPER_KEY).getAsDouble()));
                }
                case HISTORICALLY: {
                    if (json.has(FormulaJSonIO.UNBOUNDED_KEY)) {
                        return new HistoricallyFormula(this.deserializeFormula(json.get(FormulaJSonIO.ARGUMENT).getAsJsonObject(), context));
                    }
                    return new HistoricallyFormula(this.deserializeFormula(json.get(FormulaJSonIO.ARGUMENT).getAsJsonObject(), context), new Interval(json.get(FormulaJSonIO.LOWER_KEY).getAsDouble(), json.get(FormulaJSonIO.UPPER_KEY).getAsDouble()));
                }
                case ONCE: {
                    if (json.has(FormulaJSonIO.UNBOUNDED_KEY)) {
                        return new OnceFormula(this.deserializeFormula(json.get(FormulaJSonIO.ARGUMENT).getAsJsonObject(), context));
                    }
                    return new OnceFormula(this.deserializeFormula(json.get(FormulaJSonIO.ARGUMENT).getAsJsonObject(), context), new Interval(json.get(FormulaJSonIO.LOWER_KEY).getAsDouble(), json.get(FormulaJSonIO.UPPER_KEY).getAsDouble()));
                }
            }
            return null;
        }
    }

    public class FormulaSerialiser
    implements JsonSerializer<Formula>,
    FormulaVisitor<JsonSerializationContext, JsonElement> {
        public JsonElement serialize(Formula src, Type typeOfSrc, JsonSerializationContext context) {
            return src.accept(this, context);
        }

        @Override
        public JsonElement visit(AtomicFormula atomicFormula, JsonSerializationContext parameters) {
            JsonObject o = new JsonObject();
            o.addProperty(FormulaJSonIO.TYPE_KEY, FormulaType.ATOMIC.name());
            o.addProperty(FormulaJSonIO.ATOMIC_ID, atomicFormula.getAtomicId());
            return o;
        }

        @Override
        public JsonElement visit(AndFormula andFormula, JsonSerializationContext parameters) {
            JsonObject o = new JsonObject();
            o.addProperty(FormulaJSonIO.TYPE_KEY, FormulaType.AND.name());
            o.add(FormulaJSonIO.FIRST_ARGUMENT, andFormula.getFirstArgument().accept(this, parameters));
            o.add(FormulaJSonIO.SECOND_ARGUMENT, andFormula.getSecondArgument().accept(this, parameters));
            return o;
        }

        @Override
        public JsonElement visit(NegationFormula negationFormula, JsonSerializationContext parameters) {
            JsonObject o = new JsonObject();
            o.addProperty(FormulaJSonIO.TYPE_KEY, FormulaType.NOT.name());
            o.add(FormulaJSonIO.ARGUMENT, negationFormula.getArgument().accept(this, parameters));
            return o;
        }

        @Override
        public JsonElement visit(OrFormula orFormula, JsonSerializationContext parameters) {
            JsonObject o = new JsonObject();
            o.addProperty(FormulaJSonIO.TYPE_KEY, FormulaType.OR.name());
            o.add(FormulaJSonIO.FIRST_ARGUMENT, orFormula.getFirstArgument().accept(this, parameters));
            o.add(FormulaJSonIO.SECOND_ARGUMENT, orFormula.getSecondArgument().accept(this, parameters));
            return o;
        }

        @Override
        public JsonElement visit(EventuallyFormula eventuallyFormula, JsonSerializationContext parameters) {
            JsonObject o = new JsonObject();
            o.addProperty(FormulaJSonIO.TYPE_KEY, FormulaType.EVENTUALLY.name());
            Interval i = eventuallyFormula.getInterval();
            o.addProperty(FormulaJSonIO.LOWER_KEY, (Number)i.getStart());
            o.addProperty(FormulaJSonIO.UPPER_KEY, (Number)i.getEnd());
            o.add(FormulaJSonIO.ARGUMENT, eventuallyFormula.getArgument().accept(this, parameters));
            return o;
        }

        @Override
        public JsonElement visit(GloballyFormula globallyFormula, JsonSerializationContext parameters) {
            JsonObject o = new JsonObject();
            o.addProperty(FormulaJSonIO.TYPE_KEY, FormulaType.GLOBALLY.name());
            Interval i = globallyFormula.getInterval();
            o.addProperty(FormulaJSonIO.LOWER_KEY, (Number)i.getStart());
            o.addProperty(FormulaJSonIO.UPPER_KEY, (Number)i.getEnd());
            o.add(FormulaJSonIO.ARGUMENT, globallyFormula.getArgument().accept(this, parameters));
            return o;
        }

        @Override
        public JsonElement visit(UntilFormula untilFormula, JsonSerializationContext parameters) {
            JsonObject o = new JsonObject();
            o.addProperty(FormulaJSonIO.TYPE_KEY, FormulaType.UNTIL.name());
            if (untilFormula.isUnbounded()) {
                o.addProperty(FormulaJSonIO.UNBOUNDED_KEY, Boolean.valueOf(true));
            } else {
                Interval i = untilFormula.getInterval();
                o.addProperty(FormulaJSonIO.LOWER_KEY, (Number)i.getStart());
                o.addProperty(FormulaJSonIO.UPPER_KEY, (Number)i.getEnd());
            }
            o.add(FormulaJSonIO.FIRST_ARGUMENT, untilFormula.getFirstArgument().accept(this, parameters));
            o.add(FormulaJSonIO.SECOND_ARGUMENT, untilFormula.getSecondArgument().accept(this, parameters));
            return o;
        }

        @Override
        public JsonElement visit(SinceFormula sinceFormula, JsonSerializationContext parameters) {
            JsonObject o = new JsonObject();
            o.addProperty(FormulaJSonIO.TYPE_KEY, FormulaType.SINCE.name());
            if (sinceFormula.isUnbounded()) {
                o.addProperty(FormulaJSonIO.UNBOUNDED_KEY, Boolean.valueOf(true));
            } else {
                Interval i = sinceFormula.getInterval();
                o.addProperty(FormulaJSonIO.LOWER_KEY, (Number)i.getStart());
                o.addProperty(FormulaJSonIO.UPPER_KEY, (Number)i.getEnd());
            }
            o.add(FormulaJSonIO.FIRST_ARGUMENT, sinceFormula.getFirstArgument().accept(this, parameters));
            o.add(FormulaJSonIO.SECOND_ARGUMENT, sinceFormula.getSecondArgument().accept(this, parameters));
            return o;
        }

        @Override
        public JsonElement visit(HistoricallyFormula historicallyFormula, JsonSerializationContext parameters) {
            JsonObject o = new JsonObject();
            o.addProperty(FormulaJSonIO.TYPE_KEY, FormulaType.HISTORICALLY.name());
            if (historicallyFormula.isUnbounded()) {
                o.addProperty(FormulaJSonIO.UNBOUNDED_KEY, Boolean.valueOf(true));
            } else {
                Interval i = historicallyFormula.getInterval();
                o.addProperty(FormulaJSonIO.LOWER_KEY, (Number)i.getStart());
                o.addProperty(FormulaJSonIO.UPPER_KEY, (Number)i.getEnd());
            }
            o.add(FormulaJSonIO.ARGUMENT, historicallyFormula.getArgument().accept(this, parameters));
            return o;
        }

        @Override
        public JsonElement visit(OnceFormula onceFormula, JsonSerializationContext parameters) {
            JsonObject o = new JsonObject();
            o.addProperty(FormulaJSonIO.TYPE_KEY, FormulaType.ONCE.name());
            if (onceFormula.isUnbounded()) {
                o.addProperty(FormulaJSonIO.UNBOUNDED_KEY, Boolean.valueOf(true));
            } else {
                Interval i = onceFormula.getInterval();
                o.addProperty(FormulaJSonIO.LOWER_KEY, (Number)i.getStart());
                o.addProperty(FormulaJSonIO.UPPER_KEY, (Number)i.getEnd());
            }
            o.add(FormulaJSonIO.ARGUMENT, onceFormula.getArgument().accept(this, parameters));
            return o;
        }
    }
}

