/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.io;

import eu.quanticol.moonlight.core.io.DataHandler;
import eu.quanticol.moonlight.io.SpatialTemporalSignalWriter;
import eu.quanticol.moonlight.offline.signal.SpatialTemporalSignal;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class CsvSpatialTemporalSignalWriter
implements SpatialTemporalSignalWriter {
    @Override
    public <S> void write(DataHandler<S> handler, SpatialTemporalSignal<S> signal, File file) throws IOException {
        Files.write(file.toPath(), this.stringOf(handler, signal).getBytes(), new OpenOption[0]);
    }

    @Override
    public <S> String stringOf(DataHandler<S> handler, SpatialTemporalSignal<S> signal) {
        double[] timePoints = signal.getTimeArray();
        String[][] elements = new String[signal.getNumberOfLocations()][timePoints.length];
        signal.fill(timePoints, elements, handler::stringOf);
        return this.combine(signal.getNumberOfLocations(), timePoints, elements);
    }

    private String combine(int size, double[] timePoints, String[][] elements) {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append("LOCATIONS " + size + "\n");
        for (int i = 0; i < timePoints.length; ++i) {
            StringBuilder row = new StringBuilder("" + timePoints[i]);
            for (int j = 0; j < size; ++j) {
                row.append(";").append(elements[j][i]);
            }
            toReturn.append((CharSequence)row).append("\n");
        }
        return toReturn.toString();
    }
}

