/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.space;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.base.Pair;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.space.LocationServiceList;
import java.util.Iterator;

public interface LocationService<T, E> {
    public SpatialModel<E> get(T var1);

    public Iterator<Pair<T, SpatialModel<E>>> times();

    public boolean isEmpty();

    public static LocationService<Double, MoonLightRecord> buildLocationServiceFromAdjacencyMatrix(int locations, RecordHandler edgeRecordHandler, double[] locationTimeArray, String[][][][] graph) {
        LocationServiceList<MoonLightRecord> toReturn = new LocationServiceList<MoonLightRecord>();
        for (int i = 0; i < locationTimeArray.length; ++i) {
            toReturn.add(locationTimeArray[i], SpatialModel.buildSpatialModelFromAdjacencyMatrix(locations, edgeRecordHandler, graph[i]));
        }
        return toReturn;
    }

    public static LocationService<Double, MoonLightRecord> buildLocationServiceFromAdjacencyMatrix(int locations, RecordHandler edgeRecordHandler, double time, String[][][] graph) {
        LocationServiceList<MoonLightRecord> toReturn = new LocationServiceList<MoonLightRecord>();
        toReturn.add(time, SpatialModel.buildSpatialModelFromAdjacencyMatrix(locations, edgeRecordHandler, graph));
        return toReturn;
    }

    public static LocationService<Double, MoonLightRecord> buildLocationServiceFromAdjacencyMatrix(int locations, RecordHandler edgeRecordHandler, double[] locationTimeArray, double[][][][] graph) {
        LocationServiceList<MoonLightRecord> toReturn = new LocationServiceList<MoonLightRecord>();
        for (int i = 0; i < locationTimeArray.length; ++i) {
            toReturn.add(locationTimeArray[i], SpatialModel.buildSpatialModelFromAdjacencyMatrix(locations, edgeRecordHandler, graph[i]));
        }
        return toReturn;
    }

    public static LocationService<Double, MoonLightRecord> buildLocationServiceFromAdjacencyMatrix(int locations, RecordHandler edgeRecordHandler, double time, double[][][] graph) {
        LocationServiceList<MoonLightRecord> toReturn = new LocationServiceList<MoonLightRecord>();
        toReturn.add(time, SpatialModel.buildSpatialModelFromAdjacencyMatrix(locations, edgeRecordHandler, graph));
        return toReturn;
    }

    public static LocationService<Double, MoonLightRecord> buildLocationServiceFromAdjacencyList(int locations, RecordHandler edgeRecordHandler, double[] locationTimeArray, String[][][] graph) {
        LocationServiceList<MoonLightRecord> toReturn = new LocationServiceList<MoonLightRecord>();
        for (int i = 0; i < locationTimeArray.length; ++i) {
            toReturn.add(locationTimeArray[i], SpatialModel.buildSpatialModelFromAdjacencyList(locations, edgeRecordHandler, graph[i]));
        }
        return toReturn;
    }

    public static LocationService<Double, MoonLightRecord> buildLocationServiceFromAdjacencyList(int locations, RecordHandler edgeRecordHandler, double time, String[][] graph) {
        LocationServiceList<MoonLightRecord> toReturn = new LocationServiceList<MoonLightRecord>();
        toReturn.add(time, SpatialModel.buildSpatialModelFromAdjacencyList(locations, edgeRecordHandler, graph));
        return toReturn;
    }

    public static LocationService<Double, MoonLightRecord> buildLocationServiceFromAdjacencyList(int locations, RecordHandler edgeRecordHandler, double[] locationTimeArray, double[][][] graph) {
        LocationServiceList<MoonLightRecord> toReturn = new LocationServiceList<MoonLightRecord>();
        for (int i = 0; i < locationTimeArray.length; ++i) {
            toReturn.add(locationTimeArray[i], SpatialModel.buildSpatialModelFromAdjacencyList(locations, edgeRecordHandler, graph[i]));
        }
        return toReturn;
    }

    public static LocationService<Double, MoonLightRecord> buildLocationServiceFromAdjacencyList(int locations, RecordHandler edgeRecordHandler, double time, double[][] graph) {
        LocationServiceList<MoonLightRecord> toReturn = new LocationServiceList<MoonLightRecord>();
        toReturn.add(time, SpatialModel.buildSpatialModelFromAdjacencyList(locations, edgeRecordHandler, graph));
        return toReturn;
    }
}

