/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.core.base;

import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class Box<T extends Comparable<T>>
implements Comparable<Box<T>> {
    private final T start;
    private final T end;
    private final boolean openOnRight;
    private final boolean openOnLeft;

    public Box(T start, T end, boolean openOnLeft, boolean openOnRight) {
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("An Interval must have the left bound smaller than the right bound");
        }
        this.start = start;
        this.end = end;
        this.openOnLeft = openOnLeft;
        this.openOnRight = openOnRight;
    }

    public Box(T start, T end) {
        this(start, end, false, false);
    }

    public T getStart() {
        return this.start;
    }

    public T getEnd() {
        return this.end;
    }

    public boolean contains(T value) {
        if (value != null) {
            return value.compareTo(this.start) > 0 && value.compareTo(this.end) < 0 || value.equals(this.start) && !this.openOnLeft || value.equals(this.end) && !this.openOnRight;
        }
        return false;
    }

    public boolean contains(Box<?> target) {
        if (target != null) {
            Box<?> interval = target;
            return this.equals(interval) || this.contains(interval.start) && this.contains(interval.end) || this.start == interval.start && this.openOnLeft == target.openOnLeft && this.contains(interval.end) || this.end == target.end && this.openOnRight == target.openOnRight && this.contains(interval.end);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.start.equals(this.end) && (this.openOnLeft || this.openOnRight);
    }

    public boolean isOpenOnRight() {
        return this.openOnRight;
    }

    public boolean isOpenOnLeft() {
        return this.openOnLeft;
    }

    @Override
    public int compareTo(@NotNull Box<T> o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.getEnd().compareTo(o.getStart()) < 0) {
            return this.getEnd().compareTo(o.getStart());
        }
        if (this.getStart().compareTo(o.getEnd()) > 0) {
            return this.getStart().compareTo(o.getEnd());
        }
        throw new UnsupportedOperationException("Unable to compare interval  with " + o);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = this.end.hashCode();
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.openOnRight ? 1231 : 1237);
        temp = this.start.hashCode();
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Box other = (Box)obj;
        if (!this.end.equals(other.end)) {
            return false;
        }
        if (this.openOnLeft != other.openOnLeft || this.openOnRight != other.openOnRight) {
            return false;
        }
        return this.start.equals(other.start);
    }

    public String toString() {
        Object output = "Interval: ";
        output = this.openOnLeft ? (String)output + "(" : (String)output + "[";
        output = (String)output + this.start + ", " + this.end;
        output = this.openOnRight ? (String)output + ")" : (String)output + "]";
        return output;
    }

    public <R extends Comparable<R>> Box<R> apply(Function<T, R> f) {
        return new Box<Comparable>((Comparable)f.apply(this.start), (Comparable)f.apply(this.end), this.openOnLeft, this.openOnRight);
    }
}

