/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight;

import eu.quanticol.moonlight.SpatialTemporalMonitorProducer;
import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.signal.SignalDomain;
import eu.quanticol.moonlight.offline.monitoring.spatialtemporal.SpatialTemporalMonitor;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import java.util.Arrays;

public class SpatialTemporalMonitorDefinition {
    private final String name;
    private final RecordHandler arguments;
    private final RecordHandler signalRecordHandler;
    private final RecordHandler edgeRecordHandler;
    private final SpatialTemporalMonitorProducer producer;

    public SpatialTemporalMonitorDefinition(String name, RecordHandler arguments, RecordHandler signalRecordHandler, RecordHandler edgeRecordHandler, SpatialTemporalMonitorProducer producer) {
        this.name = name;
        this.arguments = arguments;
        this.signalRecordHandler = signalRecordHandler;
        this.producer = producer;
        this.edgeRecordHandler = edgeRecordHandler;
    }

    public String getName() {
        return this.name;
    }

    public RecordHandler getArguments() {
        return this.arguments;
    }

    public SpatialTemporalMonitorProducer getProducer() {
        return this.producer;
    }

    public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> getMonitor(SignalDomain<S> domain, MoonLightRecord arguments) {
        return this.producer.apply(domain, arguments);
    }

    public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> getMonitorFromString(SignalDomain<S> domain, String[] values) {
        return this.getMonitor(domain, this.arguments.fromStringArray(values));
    }

    public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> getMonitorFromDouble(SignalDomain<S> domain, double[] values) {
        return this.getMonitor(domain, this.evalArgumentFromDoubleArray(values));
    }

    private MoonLightRecord evalArgumentFromDoubleArray(double[] values) {
        if (this.arguments == null) {
            return null;
        }
        if (values == null) {
            values = new double[]{};
        }
        return this.arguments.fromDoubleArray(values);
    }

    public <S> SpatialTemporalMonitor<MoonLightRecord, MoonLightRecord, S> getMonitorFromObject(SignalDomain<S> domain, Object[] values) {
        return this.getMonitor(domain, this.arguments.fromObjectArray(values));
    }

    public RecordHandler getSignalRecordHandler() {
        return this.signalRecordHandler;
    }

    public RecordHandler getEdgeRecordHandler() {
        return this.edgeRecordHandler;
    }

    public String getInfo() {
        return this.name + Arrays.toString(this.arguments.getVariables()) + "\n Signal: " + Arrays.deepToString(this.signalRecordHandler.getVariables()) + "\n Edges:  " + Arrays.deepToString(this.edgeRecordHandler.getVariables());
    }
}

