/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.script.MoonLightScriptParser;
import eu.quanticol.moonlight.script.MoonLightType;
import eu.quanticol.moonlight.script.TypeChecker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeEnvironment {
    private Map<String, String[]> customTypes;
    private Map<String, MoonLightType> typeEnvironment;
    private Map<String, MoonLightType[]> formulas;
    private Set<String> edges;
    private Set<String> signal;
    private Set<String> location;
    private Set<String> constants;
    private Set<String> parameters;

    public TypeEnvironment() {
        this(new HashMap<String, String[]>(), new HashMap<String, MoonLightType>(), new HashMap<String, MoonLightType[]>(), new HashSet<String>(), new HashSet<String>(), new HashSet<String>(), new HashSet<String>());
    }

    public TypeEnvironment(Map<String, String[]> customTypes, Map<String, MoonLightType> typeEnvironment, Map<String, MoonLightType[]> formulas, Set<String> edges, Set<String> signal, Set<String> location, Set<String> constants) {
        this.customTypes = customTypes;
        this.typeEnvironment = typeEnvironment;
        this.formulas = formulas;
        this.edges = edges;
        this.signal = signal;
        this.location = location;
        this.constants = constants;
    }

    public synchronized void recordType(MoonLightScriptParser.ScriptTypeContext scriptTypeContext) {
        String name = scriptTypeContext.name.getText();
        this.customTypes.put(name, (String[])scriptTypeContext.elements.stream().map(te -> te.name.getText()).toArray(String[]::new));
        MoonLightType custom = MoonLightType.customType(name);
        scriptTypeContext.elements.forEach(te -> this.typeEnvironment.put(name, custom));
    }

    public synchronized void addEdge(String name, MoonLightType type) {
        this.add(name, type);
        this.edges.add(name);
    }

    public synchronized void addLocation(String name, MoonLightType type) {
        this.add(name, type);
        this.location.add(name);
    }

    public synchronized void addSignal(String name, MoonLightType type) {
        this.add(name, type);
        this.signal.add(name);
    }

    public synchronized void addFormula(String name, MoonLightType[] args) {
        this.add(name, MoonLightType.BOOLEAN);
        this.formulas.put(name, args);
    }

    public synchronized void addConstant(String name, MoonLightType type) {
        this.add(name, type);
        this.constants.add(name);
    }

    public synchronized void add(String name, MoonLightType type) {
        this.typeEnvironment.put(name, type);
    }

    public boolean exists(String name) {
        return this.typeEnvironment.containsKey(name);
    }

    public boolean isValidIn(String name, TypeChecker.EvaluationContext evaluationContext) {
        switch (evaluationContext) {
            case NONE: 
            case INTERVAL: {
                return this.constants.contains(name) || this.typeEnvironment.containsKey(name);
            }
            case EDGE: {
                return this.edges.contains(name) || this.constants.contains(name) || this.typeEnvironment.containsKey(name);
            }
            case STATE: {
                return this.constants.contains(name) || this.signal.contains(name) || this.location.contains(name) || this.formulas.containsKey(name) || this.typeEnvironment.containsKey(name);
            }
        }
        return false;
    }

    public int numberOfArguments(String name) {
        MoonLightType[] args = this.formulas.get(name);
        if (args != null) {
            return args.length;
        }
        return 0;
    }

    public MoonLightType[] getArguments(String name) {
        return this.formulas.getOrDefault(name, new MoonLightType[0]);
    }

    public MoonLightType getTypeOf(String name) {
        return this.typeEnvironment.getOrDefault(name, MoonLightType.NONE);
    }

    public TypeEnvironment addLocal(Map<String, MoonLightType> localContext) {
        if (localContext.isEmpty()) {
            return this;
        }
        HashMap<String, MoonLightType> newTypeEnvironment = new HashMap<String, MoonLightType>(this.typeEnvironment);
        newTypeEnvironment.putAll(localContext);
        return new TypeEnvironment(this.customTypes, newTypeEnvironment, this.formulas, this.edges, this.signal, this.location, this.constants);
    }
}

