/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.SpatialTemporalMonitorProducer;
import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.core.formula.Interval;
import eu.quanticol.moonlight.core.space.DefaultDistanceStructure;
import eu.quanticol.moonlight.core.space.DistanceDomain;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.domain.DoubleDomain;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.script.BiParametricExpressionEvaluator;
import eu.quanticol.moonlight.script.MoonLightScriptBaseVisitor;
import eu.quanticol.moonlight.script.MoonLightScriptParser;
import eu.quanticol.moonlight.script.NameResolver;
import eu.quanticol.moonlight.script.ParametricExpressionEvaluator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SpatialTemporalMonitoringGenerator
extends MoonLightScriptBaseVisitor<SpatialTemporalMonitorProducer> {
    private final RecordHandler inputHandler;
    private final RecordHandler signalHandler;
    private final RecordHandler edgeHandler;
    private final NameResolver resolver;
    private final Map<String, SpatialTemporalMonitorProducer> producers;
    private final Map<String, RecordHandler> formulaParameters;

    public SpatialTemporalMonitoringGenerator(Map<String, SpatialTemporalMonitorProducer> producers, NameResolver resolver, Map<String, RecordHandler> formulaParameters, RecordHandler inputHandler, RecordHandler signalHandler, RecordHandler edgeHandler) {
        this.inputHandler = inputHandler;
        this.signalHandler = signalHandler;
        this.resolver = resolver;
        this.producers = producers;
        this.edgeHandler = edgeHandler;
        this.formulaParameters = formulaParameters;
    }

    @Override
    public SpatialTemporalMonitorProducer visitImplyExpression(MoonLightScriptParser.ImplyExpressionContext ctx) {
        SpatialTemporalMonitorProducer left = (SpatialTemporalMonitorProducer)ctx.left.accept(this);
        SpatialTemporalMonitorProducer right = (SpatialTemporalMonitorProducer)ctx.right.accept(this);
        return SpatialTemporalMonitorProducer.produceImplication((SpatialTemporalMonitorProducer)left, (SpatialTemporalMonitorProducer)right);
    }

    @Override
    public SpatialTemporalMonitorProducer visitNotExpression(MoonLightScriptParser.NotExpressionContext ctx) {
        SpatialTemporalMonitorProducer arg = (SpatialTemporalMonitorProducer)ctx.arg.accept(this);
        return SpatialTemporalMonitorProducer.produceNegation((SpatialTemporalMonitorProducer)arg);
    }

    @Override
    public SpatialTemporalMonitorProducer visitFalseExpression(MoonLightScriptParser.FalseExpressionContext ctx) {
        return SpatialTemporalMonitorProducer.produceFalse();
    }

    @Override
    public SpatialTemporalMonitorProducer visitOnceExpression(MoonLightScriptParser.OnceExpressionContext ctx) {
        SpatialTemporalMonitorProducer arg = (SpatialTemporalMonitorProducer)ctx.argument.accept(this);
        if (ctx.interval() == null) {
            return SpatialTemporalMonitorProducer.produceOnce((SpatialTemporalMonitorProducer)arg);
        }
        return SpatialTemporalMonitorProducer.produceOnce((SpatialTemporalMonitorProducer)arg, this.generateIntervalFunction(ctx.interval()));
    }

    private Function<MoonLightRecord, Interval> generateIntervalFunction(MoonLightScriptParser.IntervalContext interval) {
        ParametricExpressionEvaluator evaluator = new ParametricExpressionEvaluator(this.resolver, this.inputHandler);
        Function from = (Function)interval.from.accept(evaluator);
        Function to = (Function)interval.to.accept(evaluator);
        return r -> new Interval((Number)from.apply(r), (Number)to.apply(r));
    }

    @Override
    public SpatialTemporalMonitorProducer visitBracketExpression(MoonLightScriptParser.BracketExpressionContext ctx) {
        return (SpatialTemporalMonitorProducer)ctx.expression().accept(this);
    }

    @Override
    public SpatialTemporalMonitorProducer visitUntilExpression(MoonLightScriptParser.UntilExpressionContext ctx) {
        SpatialTemporalMonitorProducer left = (SpatialTemporalMonitorProducer)ctx.left.accept(this);
        SpatialTemporalMonitorProducer right = (SpatialTemporalMonitorProducer)ctx.right.accept(this);
        if (ctx.interval() == null) {
            return SpatialTemporalMonitorProducer.produceUntil((SpatialTemporalMonitorProducer)left, (SpatialTemporalMonitorProducer)right);
        }
        Function<MoonLightRecord, Interval> interval = this.generateIntervalFunction(ctx.interval());
        return SpatialTemporalMonitorProducer.produceUntil((SpatialTemporalMonitorProducer)left, interval, (SpatialTemporalMonitorProducer)right);
    }

    @Override
    public SpatialTemporalMonitorProducer visitSinceExpression(MoonLightScriptParser.SinceExpressionContext ctx) {
        SpatialTemporalMonitorProducer left = (SpatialTemporalMonitorProducer)ctx.left.accept(this);
        SpatialTemporalMonitorProducer right = (SpatialTemporalMonitorProducer)ctx.right.accept(this);
        if (ctx.interval() == null) {
            return SpatialTemporalMonitorProducer.produceSince((SpatialTemporalMonitorProducer)left, (SpatialTemporalMonitorProducer)right);
        }
        Function<MoonLightRecord, Interval> interval = this.generateIntervalFunction(ctx.interval());
        return SpatialTemporalMonitorProducer.produceSince((SpatialTemporalMonitorProducer)left, interval, (SpatialTemporalMonitorProducer)right);
    }

    @Override
    public SpatialTemporalMonitorProducer visitAndExpression(MoonLightScriptParser.AndExpressionContext ctx) {
        SpatialTemporalMonitorProducer left = (SpatialTemporalMonitorProducer)ctx.left.accept(this);
        SpatialTemporalMonitorProducer right = (SpatialTemporalMonitorProducer)ctx.right.accept(this);
        return SpatialTemporalMonitorProducer.produceAnd((SpatialTemporalMonitorProducer)left, (SpatialTemporalMonitorProducer)right);
    }

    @Override
    public SpatialTemporalMonitorProducer visitTrueExpression(MoonLightScriptParser.TrueExpressionContext ctx) {
        return SpatialTemporalMonitorProducer.produceTrue();
    }

    @Override
    public SpatialTemporalMonitorProducer visitReferenceExpression(MoonLightScriptParser.ReferenceExpressionContext ctx) {
        String name = ctx.name.getText();
        if (this.inputHandler.isAVariable(name)) {
            int idx = this.inputHandler.getVariableIndex(name);
            return SpatialTemporalMonitorProducer.produceAtomic((r, s) -> r.getDoubleOf(idx));
        }
        if (this.signalHandler.isAVariable(name)) {
            int idx = this.signalHandler.getVariableIndex(name);
            return SpatialTemporalMonitorProducer.produceAtomic((r, s) -> s.getDoubleOf(idx));
        }
        if (this.producers.containsKey(name)) {
            RecordHandler callee = this.formulaParameters.get(name);
            ParametricExpressionEvaluator evaluator = new ParametricExpressionEvaluator(this.resolver, this.inputHandler);
            List args = ctx.args.stream().map(e -> (Function)e.accept(evaluator)).collect(Collectors.toList());
            return SpatialTemporalMonitorProducer.produceCall((SpatialTemporalMonitorProducer)this.producers.get(name), (RecordHandler)callee, args);
        }
        return this.defaultResult();
    }

    protected SpatialTemporalMonitorProducer defaultResult() {
        return SpatialTemporalMonitorProducer.produceFalse();
    }

    @Override
    public SpatialTemporalMonitorProducer visitGloballyExpression(MoonLightScriptParser.GloballyExpressionContext ctx) {
        SpatialTemporalMonitorProducer arg = (SpatialTemporalMonitorProducer)ctx.argument.accept(this);
        if (ctx.interval() == null) {
            return SpatialTemporalMonitorProducer.produceGlobally((SpatialTemporalMonitorProducer)arg);
        }
        Function<MoonLightRecord, Interval> interval = this.generateIntervalFunction(ctx.interval());
        return SpatialTemporalMonitorProducer.produceGlobally((SpatialTemporalMonitorProducer)arg, interval);
    }

    @Override
    public SpatialTemporalMonitorProducer visitOrExpression(MoonLightScriptParser.OrExpressionContext ctx) {
        SpatialTemporalMonitorProducer left = (SpatialTemporalMonitorProducer)ctx.left.accept(this);
        SpatialTemporalMonitorProducer right = (SpatialTemporalMonitorProducer)ctx.right.accept(this);
        return SpatialTemporalMonitorProducer.produceOr((SpatialTemporalMonitorProducer)left, (SpatialTemporalMonitorProducer)right);
    }

    @Override
    public SpatialTemporalMonitorProducer visitHistoricallyExpression(MoonLightScriptParser.HistoricallyExpressionContext ctx) {
        SpatialTemporalMonitorProducer arg = (SpatialTemporalMonitorProducer)ctx.argument.accept(this);
        if (ctx.interval() == null) {
            return SpatialTemporalMonitorProducer.produceHistorically((SpatialTemporalMonitorProducer)arg);
        }
        Function<MoonLightRecord, Interval> interval = this.generateIntervalFunction(ctx.interval());
        return SpatialTemporalMonitorProducer.produceHistorically((SpatialTemporalMonitorProducer)arg, interval);
    }

    @Override
    public SpatialTemporalMonitorProducer visitEventuallyExpression(MoonLightScriptParser.EventuallyExpressionContext ctx) {
        SpatialTemporalMonitorProducer arg = (SpatialTemporalMonitorProducer)ctx.argument.accept(this);
        if (ctx.interval() == null) {
            return SpatialTemporalMonitorProducer.produceEventually((SpatialTemporalMonitorProducer)arg);
        }
        Function<MoonLightRecord, Interval> interval = this.generateIntervalFunction(ctx.interval());
        return SpatialTemporalMonitorProducer.produceEventually((SpatialTemporalMonitorProducer)arg, interval);
    }

    @Override
    public SpatialTemporalMonitorProducer visitRelationExpression(MoonLightScriptParser.RelationExpressionContext ctx) {
        BiParametricExpressionEvaluator expressionEvaluator = new BiParametricExpressionEvaluator(this.resolver, this.inputHandler, this.signalHandler);
        BiFunction<MoonLightRecord, MoonLightRecord, Double> left = expressionEvaluator.eval(ctx.left);
        BiFunction<MoonLightRecord, MoonLightRecord, Double> right = expressionEvaluator.eval(ctx.right);
        return SpatialTemporalMonitorProducer.produceAtomic(left, (String)ctx.op.getText(), right);
    }

    @Override
    public SpatialTemporalMonitorProducer visitEverywhereExpression(MoonLightScriptParser.EverywhereExpressionContext ctx) {
        SpatialTemporalMonitorProducer arg = (SpatialTemporalMonitorProducer)ctx.argument.accept(this);
        Function<MoonLightRecord, Function<SpatialModel<MoonLightRecord>, DistanceStructure<MoonLightRecord, ?>>> distance = this.getDistance(ctx.distanceExpression, ctx.interval());
        return SpatialTemporalMonitorProducer.produceEverywhere((SpatialTemporalMonitorProducer)arg, distance);
    }

    private Function<MoonLightRecord, Function<SpatialModel<MoonLightRecord>, DistanceStructure<MoonLightRecord, ?>>> getDistance(MoonLightScriptParser.ExpressionContext distanceExpression, MoonLightScriptParser.IntervalContext interval) {
        DoubleDomain distance = new DoubleDomain();
        BiFunction<MoonLightRecord, MoonLightRecord, Double> distanceFunction = this.getDistanceFunction(distanceExpression);
        ParametricExpressionEvaluator evaluator = new ParametricExpressionEvaluator(this.resolver, this.inputHandler);
        Function from = (Function)interval.from.accept(evaluator);
        Function to = (Function)interval.to.accept(evaluator);
        return r -> m -> this.buildDistanceStructure((SpatialModel<MoonLightRecord>)m, e -> (Double)distanceFunction.apply((MoonLightRecord)r, (MoonLightRecord)e), (Double)from.apply(r), (Double)to.apply(r));
    }

    private DistanceStructure<MoonLightRecord, Double> buildDistanceStructure(SpatialModel<MoonLightRecord> model, Function<MoonLightRecord, Double> distance, double lowerBound, double upperBound) {
        return new DefaultDistanceStructure(distance, (DistanceDomain)new DoubleDomain(), (Object)lowerBound, (Object)upperBound, model);
    }

    private BiFunction<MoonLightRecord, MoonLightRecord, Double> getDistanceFunction(MoonLightScriptParser.ExpressionContext distanceExpression) {
        if (distanceExpression == null) {
            return (r, e) -> 1.0;
        }
        BiParametricExpressionEvaluator evaluator = new BiParametricExpressionEvaluator(this.resolver, this.inputHandler, this.edgeHandler);
        return (BiFunction)distanceExpression.accept(evaluator);
    }

    @Override
    public SpatialTemporalMonitorProducer visitReachExpression(MoonLightScriptParser.ReachExpressionContext ctx) {
        SpatialTemporalMonitorProducer left = (SpatialTemporalMonitorProducer)ctx.left.accept(this);
        SpatialTemporalMonitorProducer right = (SpatialTemporalMonitorProducer)ctx.right.accept(this);
        Function<MoonLightRecord, Function<SpatialModel<MoonLightRecord>, DistanceStructure<MoonLightRecord, ?>>> distance = this.getDistance(ctx.distanceExpression, ctx.interval());
        return SpatialTemporalMonitorProducer.produceReach((SpatialTemporalMonitorProducer)left, distance, (SpatialTemporalMonitorProducer)right);
    }

    @Override
    public SpatialTemporalMonitorProducer visitEscapeExpression(MoonLightScriptParser.EscapeExpressionContext ctx) {
        SpatialTemporalMonitorProducer arg = (SpatialTemporalMonitorProducer)ctx.argument.accept(this);
        Function<MoonLightRecord, Function<SpatialModel<MoonLightRecord>, DistanceStructure<MoonLightRecord, ?>>> distance = this.getDistance(ctx.distanceExpression, ctx.interval());
        return SpatialTemporalMonitorProducer.produceEscape((SpatialTemporalMonitorProducer)arg, distance);
    }

    @Override
    public SpatialTemporalMonitorProducer visitSomewhereExpression(MoonLightScriptParser.SomewhereExpressionContext ctx) {
        SpatialTemporalMonitorProducer arg = (SpatialTemporalMonitorProducer)ctx.argument.accept(this);
        Function<MoonLightRecord, Function<SpatialModel<MoonLightRecord>, DistanceStructure<MoonLightRecord, ?>>> distance = this.getDistance(ctx.distanceExpression, ctx.interval());
        return SpatialTemporalMonitorProducer.produceSomewhere((SpatialTemporalMonitorProducer)arg, distance);
    }

    public SpatialTemporalMonitorProducer eval(MoonLightScriptParser.ExpressionContext formula) {
        return (SpatialTemporalMonitorProducer)formula.accept(this);
    }
}

