/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.script.MoonLightScriptBaseVisitor;
import eu.quanticol.moonlight.script.MoonLightScriptParser;
import eu.quanticol.moonlight.script.ParametricExpressionEvaluator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ParametricBooleanExpressionEvaluator
extends MoonLightScriptBaseVisitor<Function<MoonLightRecord, Boolean>> {
    private final ParametricExpressionEvaluator realExpressionEvaluator;
    private static final Map<String, BiFunction<Double, Double, Boolean>> relationsMap = new HashMap<String, BiFunction<Double, Double, Boolean>>();

    public ParametricBooleanExpressionEvaluator(ParametricExpressionEvaluator realExpressionEvaluator) {
        this.realExpressionEvaluator = realExpressionEvaluator;
    }

    public boolean eval(MoonLightScriptParser.ExpressionContext guard) {
        return false;
    }

    @Override
    public Function<MoonLightRecord, Boolean> visitImplyExpression(MoonLightScriptParser.ImplyExpressionContext ctx) {
        Function left = (Function)ctx.left.accept(this);
        Function right = (Function)ctx.right.accept(this);
        return r -> (Boolean)left.apply(r) == false || (Boolean)right.apply(r) != false;
    }

    @Override
    public Function<MoonLightRecord, Boolean> visitNotExpression(MoonLightScriptParser.NotExpressionContext ctx) {
        Function arg = (Function)ctx.arg.accept(this);
        return r -> (Boolean)arg.apply(r) == false;
    }

    @Override
    public Function<MoonLightRecord, Boolean> visitFalseExpression(MoonLightScriptParser.FalseExpressionContext ctx) {
        return r -> false;
    }

    @Override
    public Function<MoonLightRecord, Boolean> visitBracketExpression(MoonLightScriptParser.BracketExpressionContext ctx) {
        return (Function)ctx.expression().accept(this);
    }

    @Override
    public Function<MoonLightRecord, Boolean> visitAndExpression(MoonLightScriptParser.AndExpressionContext ctx) {
        Function left = (Function)ctx.left.accept(this);
        Function right = (Function)ctx.right.accept(this);
        return r -> (Boolean)left.apply(r) == false || (Boolean)right.apply(r) != false;
    }

    @Override
    public Function<MoonLightRecord, Boolean> visitTrueExpression(MoonLightScriptParser.TrueExpressionContext ctx) {
        return r -> true;
    }

    @Override
    public Function<MoonLightRecord, Boolean> visitIfThenElseExpression(MoonLightScriptParser.IfThenElseExpressionContext ctx) {
        Function guard = (Function)ctx.guard.accept(this);
        Function thenBranch = (Function)ctx.guard.accept(this);
        Function elseBranch = (Function)ctx.guard.accept(this);
        return r -> (Boolean)guard.apply(r) != false ? (Boolean)thenBranch.apply(r) : (Boolean)elseBranch.apply(r);
    }

    protected Function<MoonLightRecord, Boolean> defaultResult() {
        return r -> false;
    }

    @Override
    public Function<MoonLightRecord, Boolean> visitRelationExpression(MoonLightScriptParser.RelationExpressionContext ctx) {
        Function left = (Function)ctx.left.accept(this.realExpressionEvaluator);
        Function right = (Function)ctx.right.accept(this.realExpressionEvaluator);
        return r -> relationsMap.get(ctx.op.getText()).apply((Double)left.apply(r), (Double)right.apply(r));
    }

    @Override
    public Function<MoonLightRecord, Boolean> visitReferenceExpression(MoonLightScriptParser.ReferenceExpressionContext ctx) {
        Function<MoonLightRecord, Double> fun = ctx.accept(this.realExpressionEvaluator);
        return r -> (Double)fun.apply((MoonLightRecord)r) > 0.0;
    }

    static {
        relationsMap.put("<", (x, y) -> x < y);
        relationsMap.put("<=", (x, y) -> x <= y);
        relationsMap.put("=<", (x, y) -> x <= y);
        relationsMap.put("==", Double::equals);
        relationsMap.put(">", (x, y) -> x > y);
        relationsMap.put(">=", (x, y) -> x >= y);
        relationsMap.put("=>", (x, y) -> x >= y);
    }
}

