/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.script;

import eu.quanticol.moonlight.core.base.MoonLightRecord;
import eu.quanticol.moonlight.offline.signal.RecordHandler;
import eu.quanticol.moonlight.script.BiParametricBooleanExpressionEvaluator;
import eu.quanticol.moonlight.script.MoonLightParseError;
import eu.quanticol.moonlight.script.MoonLightScriptBaseVisitor;
import eu.quanticol.moonlight.script.MoonLightScriptParser;
import eu.quanticol.moonlight.script.NameResolver;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;

public class BiParametricExpressionEvaluator
extends MoonLightScriptBaseVisitor<BiFunction<MoonLightRecord, MoonLightRecord, Double>> {
    private static final Map<String, BiFunction<Double, Double, Double>> binaryFunctionMap = new HashMap<String, BiFunction<Double, Double, Double>>();
    private static final Map<String, Function<Double, Double>> unaryFunctionMap;
    private final List<MoonLightParseError> errors;
    private final NameResolver resolver;
    private final RecordHandler firstGroupHandler;
    private final RecordHandler secondGroupHandler;
    private BiParametricBooleanExpressionEvaluator signalPredicateEvaluator;

    public BiParametricExpressionEvaluator(List<MoonLightParseError> errors, NameResolver resolver, RecordHandler firstGroupHandler, RecordHandler secondGroupHandler) {
        this.errors = errors;
        this.resolver = resolver;
        this.firstGroupHandler = firstGroupHandler;
        this.secondGroupHandler = secondGroupHandler;
    }

    public BiParametricExpressionEvaluator(NameResolver resolver, RecordHandler firstGroupHandler, RecordHandler secondGroupHandler) {
        this(new LinkedList<MoonLightParseError>(), resolver, firstGroupHandler, secondGroupHandler);
    }

    protected BiFunction<MoonLightRecord, MoonLightRecord, Double> defaultResult() {
        return (r, s) -> Double.NaN;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitBinaryMathCallExpression(MoonLightScriptParser.BinaryMathCallExpressionContext ctx) {
        BiFunction<Double, Double, Double> opFunction = this.getBinaryFunction(ctx.binaryMathFunction());
        return this.doApply(ctx, opFunction, (BiFunction)ctx.left.accept(this), (BiFunction)ctx.right.accept(this));
    }

    private BiFunction<Double, Double, Double> getBinaryFunction(MoonLightScriptParser.BinaryMathFunctionContext binaryMathFunction) {
        String funName = binaryMathFunction.getText();
        BiFunction<Double, Double, Double> fun = binaryFunctionMap.get(funName);
        if (fun == null) {
            this.errors.add(MoonLightParseError.illegalFunctionName(funName, binaryMathFunction.start));
            return (x, y) -> Double.NaN;
        }
        return fun;
    }

    private BiFunction<MoonLightRecord, MoonLightRecord, Double> doApply(ParserRuleContext ctx, BiFunction<Double, Double, Double> fun, BiFunction<MoonLightRecord, MoonLightRecord, Double> arg1, BiFunction<MoonLightRecord, MoonLightRecord, Double> arg2) {
        return (r, s) -> (Double)fun.apply((Double)arg1.apply((MoonLightRecord)r, (MoonLightRecord)s), (Double)arg2.apply((MoonLightRecord)r, (MoonLightRecord)s));
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitBracketExpression(MoonLightScriptParser.BracketExpressionContext ctx) {
        return (BiFunction)ctx.expression().accept(this);
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitUnaryMathCallExpression(MoonLightScriptParser.UnaryMathCallExpressionContext ctx) {
        Function<Double, Double> fun = this.getUnaryFunction(ctx.fun);
        return this.doApply(ctx, fun, (BiFunction)ctx.argument.accept(this));
    }

    private BiFunction<MoonLightRecord, MoonLightRecord, Double> doApply(ParserRuleContext ctx, Function<Double, Double> fun, BiFunction<MoonLightRecord, MoonLightRecord, Double> arg) {
        return (r, s) -> (Double)fun.apply((Double)arg.apply((MoonLightRecord)r, (MoonLightRecord)s));
    }

    private Function<Double, Double> getUnaryFunction(MoonLightScriptParser.UnaryMathFunctionContext unaryMathFunction) {
        String funName = unaryMathFunction.getText();
        Function<Double, Double> fun = unaryFunctionMap.get(funName);
        if (fun == null) {
            this.errors.add(MoonLightParseError.illegalFunctionName(funName, unaryMathFunction.start));
            return x -> Double.NaN;
        }
        return fun;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitRealExpression(MoonLightScriptParser.RealExpressionContext ctx) {
        return (r, s) -> Double.parseDouble(ctx.getText());
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitUnaryExpression(MoonLightScriptParser.UnaryExpressionContext ctx) {
        if (ctx.op.getText().equals("-")) {
            Function<Double, Double> fun = x -> -x.doubleValue();
            return this.doApply(ctx, fun, (BiFunction)ctx.arg.accept(this));
        }
        return (BiFunction)ctx.arg.accept(this);
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitReferenceExpression(MoonLightScriptParser.ReferenceExpressionContext ctx) {
        String name = ctx.name.getText();
        double value = this.resolver.get(name);
        if (!Double.isNaN(value)) {
            return (r, s) -> value;
        }
        if (this.firstGroupHandler.isAVariable(name)) {
            int idx = this.firstGroupHandler.getVariableIndex(name);
            return (r, s) -> r.getDoubleOf(idx);
        }
        if (this.secondGroupHandler.isAVariable(name)) {
            int vIndex = this.secondGroupHandler.getVariableIndex(name);
            return (r, s) -> s.getDoubleOf(vIndex);
        }
        this.errors.add(MoonLightParseError.useOfAnUnknownName(name, ctx));
        return (r, s) -> Double.NaN;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitIntExpression(MoonLightScriptParser.IntExpressionContext ctx) {
        double i = Integer.parseInt(ctx.getText());
        return (r, s) -> i;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitIfThenElseExpression(MoonLightScriptParser.IfThenElseExpressionContext ctx) {
        BiParametricBooleanExpressionEvaluator signalPredicateEvaluator = this.getSignalPredicateEvaluator();
        BiFunction guard = (BiFunction)ctx.guard.accept(signalPredicateEvaluator);
        BiFunction thenBranch = (BiFunction)ctx.thenExpression.accept(this);
        BiFunction elseBranch = (BiFunction)ctx.elseExpression.accept(this);
        return (r, s) -> (Boolean)guard.apply(r, s) != false ? (Double)thenBranch.apply(r, s) : (Double)elseBranch.apply(r, s);
    }

    private synchronized BiParametricBooleanExpressionEvaluator getSignalPredicateEvaluator() {
        if (this.signalPredicateEvaluator == null) {
            this.signalPredicateEvaluator = new BiParametricBooleanExpressionEvaluator(this);
        }
        return this.signalPredicateEvaluator;
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitMulDivExpression(MoonLightScriptParser.MulDivExpressionContext ctx) {
        BiFunction<Double, Double, Double> fun = ctx.op.getText().equals("*") ? (x, y) -> x * y : (x, y) -> x / y;
        return this.doApply(ctx, fun, (BiFunction)ctx.left.accept(this), (BiFunction)ctx.right.accept(this));
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitSumDifExpression(MoonLightScriptParser.SumDifExpressionContext ctx) {
        BiFunction<Double, Double, Double> fun = ctx.op.getText().equals("+") ? Double::sum : (ctx.op.getText().equals("-") ? (x, y) -> x - y : (x, y) -> x % y);
        return this.doApply(ctx, fun, (BiFunction)ctx.left.accept(this), (BiFunction)ctx.right.accept(this));
    }

    @Override
    public BiFunction<MoonLightRecord, MoonLightRecord, Double> visitInfinityExpression(MoonLightScriptParser.InfinityExpressionContext ctx) {
        return (r, s) -> Double.POSITIVE_INFINITY;
    }

    public BiFunction<MoonLightRecord, MoonLightRecord, Double> eval(MoonLightScriptParser.ExpressionContext value) {
        return (BiFunction)value.accept(this);
    }

    static {
        binaryFunctionMap.put("atan2", Math::atan2);
        binaryFunctionMap.put("hypot", Math::hypot);
        binaryFunctionMap.put("max", Math::max);
        binaryFunctionMap.put("min", Math::min);
        binaryFunctionMap.put("pow", Math::pow);
        unaryFunctionMap = new HashMap<String, Function<Double, Double>>();
        unaryFunctionMap.put("abs", Math::abs);
        unaryFunctionMap.put("acos", Math::acos);
        unaryFunctionMap.put("asin", Math::asin);
        unaryFunctionMap.put("atan", Math::atan);
        unaryFunctionMap.put("cbrt", Math::cbrt);
        unaryFunctionMap.put("ceil", Math::ceil);
        unaryFunctionMap.put("cos", Math::cos);
        unaryFunctionMap.put("cosh", Math::cosh);
        unaryFunctionMap.put("exp", Math::exp);
        unaryFunctionMap.put("expm1", Math::expm1);
        unaryFunctionMap.put("floor", Math::floor);
        unaryFunctionMap.put("log", Math::log);
        unaryFunctionMap.put("log10", Math::log10);
        unaryFunctionMap.put("log1p", Math::log1p);
        unaryFunctionMap.put("signum", Math::signum);
        unaryFunctionMap.put("sin", Math::sin);
        unaryFunctionMap.put("sqrt", Math::sqrt);
        unaryFunctionMap.put("sinh", Math::sinh);
        unaryFunctionMap.put("tan", Math::tan);
    }
}

