/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.format;

import com.databricks.labs.mosaic.codegen.format.ConvertToCodeGen$;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.types.package$;
import com.databricks.labs.mosaic.expressions.format.ConvertTo$;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, dataType) - Converts expr1 to the specified data type.", examples="\n    Examples:\n      > SELECT _FUNC_(a, 'hex');\n       {\"00001005FA...00A\"}\n      > SELECT _FUNC_(a, 'wkt');\n      \"POLYGON ((...))\"\n  ", since="1.0")
@ScalaSignature(bytes="\u0006\u0001\tUb\u0001B\u0012%\u0001FB\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tK\u0002\u0011\t\u0012)A\u0005E\"Aa\r\u0001BK\u0002\u0013\u0005q\r\u0003\u0005q\u0001\tE\t\u0015!\u0003i\u0011!\t\bA!f\u0001\n\u00039\u0007\u0002\u0003:\u0001\u0005#\u0005\u000b\u0011\u00025\t\u000bM\u0004A\u0011\u0001;\t\u000bi\u0004A\u0011I>\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001BBA\r\u0001\u0011\u0005s\rC\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u0011Q\b\u0001\u0005R\u0005}\u0002bBA.\u0001\u0011\u0005\u0011q\u0001\u0005\u0007\u0003;\u0002A\u0011I1\t\u000f\u0005}\u0003\u0001\"\u0015\u0002b!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0003c\u0002\u0011\u0013!C\u0001\u0003gB\u0011\"!#\u0001#\u0003%\t!a#\t\u0013\u0005=\u0005!%A\u0005\u0002\u0005-\u0005\"CAI\u0001\u0005\u0005I\u0011IAJ\u0011%\t\u0019\u000bAA\u0001\n\u0003\t)\u000bC\u0005\u0002.\u0002\t\t\u0011\"\u0001\u00020\"I\u0011Q\u0017\u0001\u0002\u0002\u0013\u0005\u0013q\u0017\u0005\n\u0003\u000b\u0004\u0011\u0011!C\u0001\u0003\u000fD\u0011\"!5\u0001\u0003\u0003%\t%a5\b\u000f\u0005EH\u0005#\u0001\u0002t\u001a11\u0005\nE\u0001\u0003kDaa]\u000f\u0005\u0002\u0005]\bbBA};\u0011\u0005\u00111 \u0005\n\u0005#i\u0012\u0011!CA\u0005'A\u0011Ba\u0007\u001e\u0003\u0003%\tI!\b\t\u0013\t-R$!A\u0005\n\t5\"!C\"p]Z,'\u000f\u001e+p\u0015\t)c%\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003O!\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011FK\u0001\u0007[>\u001c\u0018-[2\u000b\u0005-b\u0013\u0001\u00027bENT!!\f\u0018\u0002\u0015\u0011\fG/\u00192sS\u000e\\7OC\u00010\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001!'Q,^!\t\u0019t(D\u00015\u0015\t9SG\u0003\u00027o\u0005A1-\u0019;bYf\u001cHO\u0003\u00029s\u0005\u00191/\u001d7\u000b\u0005iZ\u0014!B:qCJ\\'B\u0001\u001f>\u0003\u0019\t\u0007/Y2iK*\ta(A\u0002pe\u001eL!\u0001\u0011\u001b\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"A\u0011+\u000f\u0005\r\u0013fB\u0001#R\u001d\t)\u0005K\u0004\u0002G\u001f:\u0011qI\u0014\b\u0003\u00116s!!\u0013'\u000e\u0003)S!a\u0013\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0014B\u0001\u001f>\u0013\tQ4(\u0003\u00029s%\u0011agN\u0005\u0003OUJ!a\u0015\u001b\u0002\u000fA\f7m[1hK&\u0011QK\u0016\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t\u0019F\u0007\u0005\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016LA\u0004Qe>$Wo\u0019;\u0011\u0005as\u0016BA0Z\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003)IgnR3p[\u0016$(/_\u000b\u0002EB\u00111gY\u0005\u0003IR\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003-IgnR3p[\u0016$(/\u001f\u0011\u0002\u0017=,H\u000fR1uCRK\b/Z\u000b\u0002QB\u0011\u0011.\u001c\b\u0003U.\u0004\"!S-\n\u00051L\u0016A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\\-\u0002\u0019=,H\u000fR1uCRK\b/\u001a\u0011\u0002\u001f\u001d,w.\\3uef\f\u0005+\u0013(b[\u0016\f\u0001cZ3p[\u0016$(/_!Q\u0013:\u000bW.\u001a\u0011\u0002\rqJg.\u001b;?)\u0011)x\u000f_=\u0011\u0005Y\u0004Q\"\u0001\u0013\t\u000b\u0001<\u0001\u0019\u00012\t\u000b\u0019<\u0001\u0019\u00015\t\u000bE<\u0001\u0019\u00015\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003q\u00042!`A\u0001\u001b\u0005q(BA@6\u0003!\tg.\u00197zg&\u001c\u0018bAA\u0002}\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0005eCR\fG+\u001f9f+\t\tI\u0001\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\tyaN\u0001\u0006if\u0004Xm]\u0005\u0005\u0003'\tiA\u0001\u0005ECR\fG+\u001f9f\u0003!!xn\u0015;sS:<G#\u00015\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003\u0002 \u0005\u0015\u0002c\u0001-\u0002\"%\u0019\u00111E-\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002(1\u0001\r!a\b\u0002\u000b%t\u0007/\u001e;\u0002\u00115\f7.Z\"paf$2AYA\u0017\u0011\u001d\ty#\u0004a\u0001\u0003c\tqA\\3x\u0003J<7\u000fE\u0003Y\u0003g\t9$C\u0002\u00026e\u0013Q!\u0011:sCf\u00042\u0001WA\u001d\u0013\r\tY$\u0017\u0002\u0007\u0003:L(+\u001a4\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA!\u0003\u001b\n9\u0006\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9\u0005N\u0001\bG>$WmZ3o\u0013\u0011\tY%!\u0012\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0014\u000f\u0001\u0004\t\t&A\u0002dib\u0004B!a\u0011\u0002T%!\u0011QKA#\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u0017\u000f\u0001\u0004\t\t%\u0001\u0002fm\u0006Qq-\u001a;PkR$\u0016\u0010]3\u0002\u000b\rD\u0017\u000e\u001c3\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r\u0011\u00171\r\u0005\u0007\u0003K\n\u0002\u0019\u00012\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR9Q/a\u001b\u0002n\u0005=\u0004b\u00021\u0013!\u0003\u0005\rA\u0019\u0005\bMJ\u0001\n\u00111\u0001i\u0011\u001d\t(\u0003%AA\u0002!\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002v)\u001a!-a\u001e,\u0005\u0005e\u0004\u0003BA>\u0003\u000bk!!! \u000b\t\u0005}\u0014\u0011Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a!Z\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\u000biHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u000e*\u001a\u0001.a\u001e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!&\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006!A.\u00198h\u0015\t\ty*\u0001\u0003kCZ\f\u0017b\u00018\u0002\u001a\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0015\t\u00041\u0006%\u0016bAAV3\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qDAY\u0011%\t\u0019\fGA\u0001\u0002\u0004\t9+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003s\u0003b!a/\u0002B\u0006}QBAA_\u0015\r\ty,W\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAb\u0003{\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011ZAh!\rA\u00161Z\u0005\u0004\u0003\u001bL&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003gS\u0012\u0011!a\u0001\u0003?\ta!Z9vC2\u001cH\u0003BAe\u0003+D\u0011\"a-\u001c\u0003\u0003\u0005\r!a\b)\u001f\u0001\tI.a8\u0002b\u0006\u0015\u0018q]Av\u0003[\u00042aMAn\u0013\r\ti\u000e\u000e\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019/\u0001#`\rVs5i\u0018\u0015fqB\u0014\u0018\u0007\f\u0011eCR\fG+\u001f9fS\u0001j\u0003eQ8om\u0016\u0014Ho\u001d\u0011fqB\u0014\u0018\u0007\t;pAQDW\rI:qK\u000eLg-[3eA\u0011\fG/\u0019\u0011usB,g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI/AA\b\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nG\u0006I\u0014iKb<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|EA\u0002\u0004\u0007M\u00191aU2\u0015I\f\u0018/aA\n%% \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)C2\u0002se^6uO%Z$\u0002\t\u0011!A\u0001\u0002#\u0005U(M3\u001e{e\n\t\u0015)]9r\u0013&\u000b\u0012\u000bA\u0001\nQa]5oG\u0016\f#!a<\u0002\u0007Er\u0003'A\u0005D_:4XM\u001d;U_B\u0011a/H\n\u0005;\u0005]R\f\u0006\u0002\u0002t\u00061\"/Z4jgR\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0013:4w\u000e\u0006\u0004\u0002~\n\r!Q\u0002\t\u0004g\u0005}\u0018b\u0001B\u0001i\tqQ\t\u001f9sKN\u001c\u0018n\u001c8J]\u001a|\u0007b\u0002B\u0003?\u0001\u0007!qA\u0001\u0003I\n\u0004B\u0001\u0017B\u0005Q&\u0019!1B-\u0003\r=\u0003H/[8o\u0011\u0019\u0011ya\ba\u0001Q\u0006!a.Y7f\u0003\u0015\t\u0007\u000f\u001d7z)\u001d)(Q\u0003B\f\u00053AQ\u0001\u0019\u0011A\u0002\tDQA\u001a\u0011A\u0002!DQ!\u001d\u0011A\u0002!\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003 \t\u001d\u0002#\u0002-\u0003\n\t\u0005\u0002C\u0002-\u0003$\tD\u0007.C\u0002\u0003&e\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\u0015C\u0005\u0005\t\u0019A;\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0018!\u0011\t9J!\r\n\t\tM\u0012\u0011\u0014\u0002\u0007\u001f\nTWm\u0019;")
public class ConvertTo
extends UnaryExpression
implements package.NullIntolerant,
scala.Serializable {
    private final Expression inGeometry;
    private final String outDataType;
    private final String geometryAPIName;

    public static Option<Tuple3<Expression, String, String>> unapply(ConvertTo convertTo) {
        return ConvertTo$.MODULE$.unapply(convertTo);
    }

    public static ExpressionInfo registryExpressionInfo(Option<String> option, String string) {
        return ConvertTo$.MODULE$.registryExpressionInfo(option, string);
    }

    public Expression inGeometry() {
        return this.inGeometry;
    }

    public String outDataType() {
        return this.outDataType;
    }

    public String geometryAPIName() {
        return this.geometryAPIName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.inGeometry().dataType(), (Object)this.outDataType().toUpperCase(Locale.ROOT));
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && "WKT".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && "WKB".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && "COORDS".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && "HEX".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && "GEOJSON".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && "KRYO".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && "WKT".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && "WKB".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && "COORDS".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && "HEX".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && "GEOJSON".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && "KRYO".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType2 = package$.MODULE$.HexType();
            DataType dataType3 = dataType;
            if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null) && "WKT".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType4 = package$.MODULE$.HexType();
            DataType dataType5 = dataType;
            if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null) && "WKB".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType6 = package$.MODULE$.HexType();
            DataType dataType7 = dataType;
            if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null) && "COORDS".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType8 = package$.MODULE$.HexType();
            DataType dataType9 = dataType;
            if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null) && "HEX".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType10 = package$.MODULE$.HexType();
            DataType dataType11 = dataType;
            if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null) && "GEOJSON".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType12 = package$.MODULE$.HexType();
            DataType dataType13 = dataType;
            if (!(dataType12 != null ? !dataType12.equals(dataType13) : dataType13 != null) && "KRYO".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType14 = package$.MODULE$.JSONType();
            DataType dataType15 = dataType;
            if (!(dataType14 != null ? !dataType14.equals(dataType15) : dataType15 != null) && "WKT".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType16 = package$.MODULE$.JSONType();
            DataType dataType17 = dataType;
            if (!(dataType16 != null ? !dataType16.equals(dataType17) : dataType17 != null) && "WKB".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType18 = package$.MODULE$.JSONType();
            DataType dataType19 = dataType;
            if (!(dataType18 != null ? !dataType18.equals(dataType19) : dataType19 != null) && "HEX".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType20 = package$.MODULE$.JSONType();
            DataType dataType21 = dataType;
            if (!(dataType20 != null ? !dataType20.equals(dataType21) : dataType21 != null) && "COORDS".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType22 = package$.MODULE$.JSONType();
            DataType dataType23 = dataType;
            if (!(dataType22 != null ? !dataType22.equals(dataType23) : dataType23 != null) && "GEOJSON".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType24 = package$.MODULE$.JSONType();
            DataType dataType25 = dataType;
            if (!(dataType24 != null ? !dataType24.equals(dataType25) : dataType25 != null) && "KRYO".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType26 = package$.MODULE$.InternalGeometryType();
            DataType dataType27 = dataType;
            if (!(dataType26 != null ? !dataType26.equals(dataType27) : dataType27 != null) && "WKB".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType28 = package$.MODULE$.InternalGeometryType();
            DataType dataType29 = dataType;
            if (!(dataType28 != null ? !dataType28.equals(dataType29) : dataType29 != null) && "WKT".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType30 = package$.MODULE$.InternalGeometryType();
            DataType dataType31 = dataType;
            if (!(dataType30 != null ? !dataType30.equals(dataType31) : dataType31 != null) && "COORDS".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType32 = package$.MODULE$.InternalGeometryType();
            DataType dataType33 = dataType;
            if (!(dataType32 != null ? !dataType32.equals(dataType33) : dataType33 != null) && "HEX".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType34 = package$.MODULE$.InternalGeometryType();
            DataType dataType35 = dataType;
            if (!(dataType34 != null ? !dataType34.equals(dataType35) : dataType35 != null) && "GEOJSON".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType36 = package$.MODULE$.InternalGeometryType();
            DataType dataType37 = dataType;
            if (!(dataType36 != null ? !dataType36.equals(dataType37) : dataType37 != null) && "KRYO".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType38 = package$.MODULE$.KryoType();
            DataType dataType39 = dataType;
            if (!(dataType38 != null ? !dataType38.equals(dataType39) : dataType39 != null) && "WKB".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType40 = package$.MODULE$.KryoType();
            DataType dataType41 = dataType;
            if (!(dataType40 != null ? !dataType40.equals(dataType41) : dataType41 != null) && "WKT".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType42 = package$.MODULE$.KryoType();
            DataType dataType43 = dataType;
            if (!(dataType42 != null ? !dataType42.equals(dataType43) : dataType43 != null) && "COORDS".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType44 = package$.MODULE$.KryoType();
            DataType dataType45 = dataType;
            if (!(dataType44 != null ? !dataType44.equals(dataType45) : dataType45 != null) && "HEX".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            DataType dataType46 = package$.MODULE$.KryoType();
            DataType dataType47 = dataType;
            if (!(dataType46 != null ? !dataType46.equals(dataType47) : dataType47 != null) && "GEOJSON".equals(string)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(24).append("Cannot convert from ").append(this.inGeometry().dataType().sql()).append(" to ").append(this.dataType()).toString());
        DataType dataType = (DataType)tuple2._1();
        String string = (String)tuple2._2();
        DataType dataType48 = package$.MODULE$.KryoType();
        DataType dataType49 = dataType;
        if (dataType48 == null) {
            if (dataType49 != null) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(24).append("Cannot convert from ").append(this.inGeometry().dataType().sql()).append(" to ").append(this.dataType()).toString());
            }
        } else if (!dataType48.equals(dataType49)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(24).append("Cannot convert from ").append(this.inGeometry().dataType().sql()).append(" to ").append(this.dataType()).toString());
        if (!"KRYO".equals(string)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(24).append("Cannot convert from ").append(this.inGeometry().dataType().sql()).append(" to ").append(this.dataType()).toString());
        return TypeCheckResult.TypeCheckSuccess$.MODULE$;
    }

    public DataType dataType() {
        StringType$ stringType$;
        String string = this.outDataType().toUpperCase(Locale.ROOT);
        if ("WKT".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("WKB".equals(string)) {
            stringType$ = BinaryType$.MODULE$;
        } else if ("HEX".equals(string)) {
            stringType$ = package$.MODULE$.HexType();
        } else if ("COORDS".equals(string)) {
            stringType$ = package$.MODULE$.InternalGeometryType();
        } else if ("GEOJSON".equals(string)) {
            stringType$ = package$.MODULE$.JSONType();
        } else if ("KRYO".equals(string)) {
            stringType$ = package$.MODULE$.KryoType();
        } else {
            throw new MatchError((Object)string);
        }
        return stringType$;
    }

    public String toString() {
        return new StringBuilder(14).append("convert_to(").append(this.inGeometry()).append(", ").append(this.outDataType()).append(")").toString();
    }

    public String prettyName() {
        return "convert_to";
    }

    public Object nullSafeEval(Object input) {
        Object object;
        String string = this.inGeometry().dataType().simpleString();
        String string2 = this.getOutType().simpleString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            object = input;
        } else {
            GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(this.geometryAPIName());
            MosaicGeometry geometry = geometryAPI.geometry(input, this.inGeometry().dataType());
            object = geometryAPI.serialize(geometry, this.outDataType());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Expression makeCopy(Object[] newArgs) {
        void var2_2;
        ConvertTo res = new ConvertTo((Expression)newArgs[0], this.outDataType(), this.geometryAPIName());
        res.copyTagsFrom((TreeNode)this);
        return var2_2;
    }

    public ExprCode doGenCode(CodegenContext ctx2, ExprCode ev2) {
        GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(this.geometryAPIName());
        return ConvertToCodeGen$.MODULE$.doCodeGenESRI(ctx2, ev2, (Function3<CodegenContext, ExprCode, Function1<String, String>, ExprCode>)(Function3 & Serializable & scala.Serializable)(ctx, ev, f) -> this.nullSafeCodeGen((CodegenContext)ctx, (ExprCode)ev, (Function1)f), this.child().dataType(), this.getOutType(), geometryAPI);
    }

    public DataType getOutType() {
        StringType$ stringType$;
        String string = this.outDataType().toUpperCase(Locale.ROOT);
        if ("WKT".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("WKB".equals(string)) {
            stringType$ = BinaryType$.MODULE$;
        } else if ("HEX".equals(string)) {
            stringType$ = package$.MODULE$.HexType();
        } else if ("JSON".equals(string)) {
            stringType$ = package$.MODULE$.JSONType();
        } else if ("GEOJSON".equals(string)) {
            stringType$ = package$.MODULE$.JSONType();
        } else if ("COORDS".equals(string)) {
            stringType$ = package$.MODULE$.InternalGeometryType();
        } else {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        return stringType$;
    }

    public Expression child() {
        return this.inGeometry();
    }

    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public ConvertTo copy(Expression inGeometry, String outDataType, String geometryAPIName) {
        return new ConvertTo(inGeometry, outDataType, geometryAPIName);
    }

    public Expression copy$default$1() {
        return this.inGeometry();
    }

    public String copy$default$2() {
        return this.outDataType();
    }

    public String copy$default$3() {
        return this.geometryAPIName();
    }

    public String productPrefix() {
        return "ConvertTo";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.inGeometry();
                break;
            }
            case 1: {
                object = this.outDataType();
                break;
            }
            case 2: {
                object = this.geometryAPIName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ConvertTo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ConvertTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        ConvertTo convertTo = (ConvertTo)((Object)x$1);
        Expression expression = this.inGeometry();
        Expression expression2 = convertTo.inGeometry();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        String string = this.outDataType();
        String string2 = convertTo.outDataType();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.geometryAPIName();
        String string4 = convertTo.geometryAPIName();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (!convertTo.canEqual((Object)this)) return false;
        return true;
    }

    public ConvertTo(Expression inGeometry, String outDataType, String geometryAPIName) {
        this.inGeometry = inGeometry;
        this.outDataType = outDataType;
        this.geometryAPIName = geometryAPIName;
    }
}

