/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.constructors;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalCoord;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import com.databricks.labs.mosaic.core.types.package$;
import com.databricks.labs.mosaic.expressions.constructors.ST_MakeLine$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(expr1) - Creates a new LineString geometry from an Array of Point, MultiPoint, LineString or MultiLineString geometries.", examples="\n    Examples:\n      > SELECT _FUNC_(A);\n  ", since="1.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u000f\u001f\u0001.B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003S\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015!\u0007\u0001\"\u0011L\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015)\b\u0001\"\u0011w\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\tI\u0002\u0001C!\u00037Aq!!\f\u0001\t#\ny\u0003C\u0005\u00026\u0001\t\t\u0011\"\u0001\u00028!I\u0011Q\b\u0001\u0012\u0002\u0013\u0005\u0011q\b\u0005\n\u0003+\u0002\u0011\u0013!C\u0001\u0003/B\u0011\"a\u0017\u0001\u0003\u0003%\t%!\u0018\t\u0013\u00055\u0004!!A\u0005\u0002\u0005=\u0004\"CA<\u0001\u0005\u0005I\u0011AA=\u0011%\ty\bAA\u0001\n\u0003\n\t\tC\u0005\u0002\u0010\u0002\t\t\u0011\"\u0001\u0002\u0012\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0013qS\u0004\b\u0003ks\u0002\u0012AA\\\r\u0019ib\u0004#\u0001\u0002:\"1al\u0006C\u0001\u0003wCq!!0\u0018\t\u0003\ty\fC\u0005\u0002R^\t\t\u0011\"!\u0002T\"I\u0011\u0011\\\f\u0002\u0002\u0013\u0005\u00151\u001c\u0005\n\u0003S<\u0012\u0011!C\u0005\u0003W\u00141b\u0015+`\u001b\u0006\\W\rT5oK*\u0011q\u0004I\u0001\rG>t7\u000f\u001e:vGR|'o\u001d\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\u0007[>\u001c\u0018-[2\u000b\u0005\u00152\u0013\u0001\u00027bENT!a\n\u0015\u0002\u0015\u0011\fG/\u00192sS\u000e\\7OC\u0001*\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001AfO!H!\ti\u0013(D\u0001/\u0015\t\tsF\u0003\u00021c\u0005A1-\u0019;bYf\u001cHO\u0003\u00023g\u0005\u00191/\u001d7\u000b\u0005Q*\u0014!B:qCJ\\'B\u0001\u001c8\u0003\u0019\t\u0007/Y2iK*\t\u0001(A\u0002pe\u001eL!A\u000f\u0018\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001P \u000e\u0003uR!A\u0010\u0018\u0002\u000f\r|G-Z4f]&\u0011\u0001)\u0010\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n9\u0001K]8ek\u000e$\bC\u0001\"I\u0013\tI5I\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003hK>l7/F\u0001M!\tiS*\u0003\u0002O]\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\u001d,w.\\:!\u0003=9Wm\\7fiJL\u0018\tU%OC6,W#\u0001*\u0011\u0005MSfB\u0001+Y!\t)6)D\u0001W\u0015\t9&&\u0001\u0004=e>|GOP\u0005\u00033\u000e\u000ba\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011lQ\u0001\u0011O\u0016|W.\u001a;ss\u0006\u0003\u0016JT1nK\u0002\na\u0001P5oSRtDc\u00011cGB\u0011\u0011\rA\u0007\u0002=!)!*\u0002a\u0001\u0019\")\u0001+\u0002a\u0001%\u0006)1\r[5mI\u0006Aa.\u001e7mC\ndW-F\u0001h!\t\u0011\u0005.\u0003\u0002j\u0007\n9!i\\8mK\u0006t\u0017\u0001B3wC2$\"\u0001\\8\u0011\u0005\tk\u0017B\u00018D\u0005\r\te.\u001f\u0005\ba\"\u0001\n\u00111\u0001r\u0003\u0015Ig\u000e];u!\t\u00118/D\u00010\u0013\t!xFA\u0006J]R,'O\\1m%><\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003]\u0004\"\u0001_>\u000e\u0003eT!A_\u0019\u0002\u000bQL\b/Z:\n\u0005qL(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0017I,G-^2f\u000f\u0016|Wn\u001d\u000b\u0006\u007f\u0006E\u0011Q\u0003\t\u0005\u0003\u0003\ti!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u0015iw\u000eZ3m\u0015\rQ\u0018\u0011\u0002\u0006\u0004\u0003\u0017\u0011\u0013\u0001B2pe\u0016LA!a\u0004\u0002\u0004\t\u0001\u0012J\u001c;fe:\fGnR3p[\u0016$(/\u001f\u0005\u0007\u0003'Q\u0001\u0019A@\u0002\u00111,g\r^$f_6Da!a\u0006\u000b\u0001\u0004y\u0018!\u0003:jO\"$x)Z8n\u0003!i\u0017m[3D_BLHc\u0001'\u0002\u001e!9\u0011qD\u0006A\u0002\u0005\u0005\u0012a\u00028fo\u0006\u0013xm\u001d\t\u0006\u0005\u0006\r\u0012qE\u0005\u0004\u0003K\u0019%!B!se\u0006L\bc\u0001\"\u0002*%\u0019\u00111F\"\u0003\r\u0005s\u0017PU3g\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019A*!\r\t\r\u0005MB\u00021\u0001M\u0003!qWm^\"iS2$\u0017\u0001B2paf$R\u0001YA\u001d\u0003wAqAS\u0007\u0011\u0002\u0003\u0007A\nC\u0004Q\u001bA\u0005\t\u0019\u0001*\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\t\u0016\u0004\u0019\u0006\r3FAA#!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=3)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0015\u0002J\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\f\u0016\u0004%\u0006\r\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002`A!\u0011\u0011MA6\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014\u0001\u00027b]\u001eT!!!\u001b\u0002\t)\fg/Y\u0005\u00047\u0006\r\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA9!\r\u0011\u00151O\u0005\u0004\u0003k\u001a%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00017\u0002|!I\u0011Q\u0010\n\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0005#BAC\u0003\u0017cWBAAD\u0015\r\tIiQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAG\u0003\u000f\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019q-a%\t\u0011\u0005uD#!AA\u00021\fa!Z9vC2\u001cHcA4\u0002\u001a\"A\u0011QP\u000b\u0002\u0002\u0003\u0007A\u000eK\b\u0001\u0003;\u000b\u0019+!*\u0002*\u0006-\u0016qVAY!\ri\u0013qT\u0005\u0004\u0003Cs#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003O\u000bqp\u0018$V\u001d\u000e{\u0006&\u001a=qeFJ\u0003%\f\u0011De\u0016\fG/Z:!C\u0002rWm\u001e\u0011MS:,7\u000b\u001e:j]\u001e\u0004s-Z8nKR\u0014\u0018\u0010\t4s_6\u0004\u0013M\u001c\u0011BeJ\f\u0017\u0010I8gAA{\u0017N\u001c;-A5+H\u000e^5Q_&tG\u000f\f\u0011MS:,7\u000b\u001e:j]\u001e\u0004sN\u001d\u0011Nk2$\u0018\u000eT5oKN#(/\u001b8hA\u001d,w.\\3ue&,7OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QV\u0001,\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0015f\u000f\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111W\u0001\u0004c9\u0002\u0014aC*U?6\u000b7.\u001a'j]\u0016\u0004\"!Y\f\u0014\t]\t9c\u0012\u000b\u0003\u0003o\u000baC]3hSN$(/_#yaJ,7o]5p]&sgm\u001c\u000b\u0005\u0003\u0003\f9\rE\u0002.\u0003\u0007L1!!2/\u00059)\u0005\u0010\u001d:fgNLwN\\%oM>Dq!!3\u001a\u0001\u0004\tY-\u0001\u0002eEB!!)!4S\u0013\r\tym\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0001\f).a6\t\u000b)S\u0002\u0019\u0001'\t\u000bAS\u0002\u0019\u0001*\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q\\As!\u0015\u0011\u0015QZAp!\u0015\u0011\u0015\u0011\u001d'S\u0013\r\t\u0019o\u0011\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005\u001d8$!AA\u0002\u0001\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\b\u0003BA1\u0003_LA!!=\u0002d\t1qJ\u00196fGR\u0004")
public class ST_MakeLine
extends UnaryExpression
implements CodegenFallback,
scala.Serializable {
    private final Expression geoms;
    private final String geometryAPIName;

    public static Option<Tuple2<Expression, String>> unapply(ST_MakeLine sT_MakeLine) {
        return ST_MakeLine$.MODULE$.unapply(sT_MakeLine);
    }

    public static ExpressionInfo registryExpressionInfo(Option<String> option) {
        return ST_MakeLine$.MODULE$.registryExpressionInfo(option);
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$((CodegenFallback)this, (CodegenContext)ctx, (ExprCode)ev);
    }

    public Expression geoms() {
        return this.geoms;
    }

    public String geometryAPIName() {
        return this.geometryAPIName;
    }

    public Expression child() {
        return this.geoms();
    }

    public boolean nullable() {
        return true;
    }

    public Object eval(InternalRow input) {
        Object object;
        Object evaluated = this.geoms().eval(input);
        if (Option$.MODULE$.apply(evaluated).isEmpty()) {
            object = null;
        } else {
            ArrayData dataArray = (ArrayData)evaluated;
            int n = dataArray.numElements();
            boolean anyNull = ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> dataArray.isNullAt(i), IndexedSeq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ST_MakeLine.$anonfun$eval$2(BoxesRunTime.unboxToBoolean((Object)x))));
            if (anyNull) {
                object = null;
            } else {
                GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(this.geometryAPIName());
                Object[] geomArray = ((ArrayData)evaluated).toObjectArray(this.dataType());
                MosaicGeometry[] geomPieces = (MosaicGeometry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(geomArray)).map((Function1 & Serializable & scala.Serializable)x$1 -> geometryAPI.geometry(x$1, this.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MosaicGeometry.class)));
                InternalGeometry[] internalGeoms = (InternalGeometry[])Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geomPieces)).map((Function1 & Serializable & scala.Serializable)x$2 -> geometryAPI.serialize((MosaicGeometry)x$2, package$.MODULE$.InternalGeometryType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).map((Function1 & Serializable & scala.Serializable)geom -> InternalGeometry$.MODULE$.apply((InternalRow)geom), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalGeometry.class)));
                InternalGeometry outputGeom = (InternalGeometry)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])internalGeoms)).reduce((Function2 & Serializable & scala.Serializable)(leftGeom, rightGeom) -> this.reduceGeoms((InternalGeometry)leftGeom, (InternalGeometry)rightGeom));
                MosaicGeometry result = geometryAPI.geometry(outputGeom.serialize(), package$.MODULE$.InternalGeometryType());
                MosaicPoint[] points = (MosaicPoint[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geomPieces)).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getShellPoints(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).flatten((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(MosaicPoint.class));
                MosaicGeometry outputGeom2 = geometryAPI.geometry((Seq<MosaicPoint>)Predef$.MODULE$.wrapRefArray((Object[])points), GeometryTypeEnum$.MODULE$.LINESTRING());
                MosaicGeometry x2 = ((MosaicGeometry)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geomPieces)).last()).getBoundary();
                object = geometryAPI.serialize(result, this.dataType());
            }
        }
        return object;
    }

    public DataType dataType() {
        return ((ArrayType)this.geoms().dataType()).elementType();
    }

    public InternalGeometry reduceGeoms(InternalGeometry leftGeom, InternalGeometry rightGeom) {
        return new InternalGeometry(GeometryTypeEnum$.MODULE$.LINESTRING().id(), leftGeom.srid(), (InternalCoord[][])((Object[])new InternalCoord[][]{(InternalCoord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftGeom.boundaries())).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4)).toList(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalCoord.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightGeom.boundaries())).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5)).toList(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalCoord.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalCoord.class)))}), (InternalCoord[][][])((Object[])new InternalCoord[][][]{(InternalCoord[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(InternalCoord.class)))}));
    }

    /*
     * WARNING - void declaration
     */
    public Expression makeCopy(Object[] newArgs) {
        void var3_3;
        Expression[] asArray = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(newArgs)).take(1))).map((Function1 & Serializable & scala.Serializable)x$6 -> (Expression)x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
        ST_MakeLine res = new ST_MakeLine((Expression)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])asArray)).head(), this.geometryAPIName());
        res.copyTagsFrom((TreeNode)this);
        return var3_3;
    }

    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public ST_MakeLine copy(Expression geoms, String geometryAPIName) {
        return new ST_MakeLine(geoms, geometryAPIName);
    }

    public Expression copy$default$1() {
        return this.geoms();
    }

    public String copy$default$2() {
        return this.geometryAPIName();
    }

    public String productPrefix() {
        return "ST_MakeLine";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.geoms();
                break;
            }
            case 1: {
                object = this.geometryAPIName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ST_MakeLine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ST_MakeLine)) return false;
        boolean bl = true;
        if (!bl) return false;
        ST_MakeLine sT_MakeLine = (ST_MakeLine)((Object)x$1);
        Expression expression = this.geoms();
        Expression expression2 = sT_MakeLine.geoms();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        String string = this.geometryAPIName();
        String string2 = sT_MakeLine.geometryAPIName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!sT_MakeLine.canEqual((Object)this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$2(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public ST_MakeLine(Expression geoms, String geometryAPIName) {
        this.geoms = geoms;
        this.geometryAPIName = geometryAPIName;
        CodegenFallback.$init$((CodegenFallback)this);
    }
}

