/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.multilinestring;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryESRI$;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineStringESRI;
import com.databricks.labs.mosaic.core.geometry.multilinestring.MosaicMultiLineStringESRI;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalCoord;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCMultiLineString;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MosaicMultiLineStringESRI$
implements GeometryReader,
scala.Serializable {
    public static MosaicMultiLineStringESRI$ MODULE$;
    private final int defaultSpatialReferenceId;

    static {
        new MosaicMultiLineStringESRI$();
    }

    @Override
    public int defaultSpatialReferenceId() {
        return this.defaultSpatialReferenceId;
    }

    @Override
    public void com$databricks$labs$mosaic$core$geometry$GeometryReader$_setter_$defaultSpatialReferenceId_$eq(int x$1) {
        this.defaultSpatialReferenceId = x$1;
    }

    @Override
    public MosaicGeometry fromInternal(InternalRow row) {
        InternalGeometry internalGeom = InternalGeometry$.MODULE$.apply(row);
        Polyline polygon = this.createPolyline(internalGeom.boundaries(), this.createPolyline$default$2());
        SpatialReference spatialReference = internalGeom.srid() != 0 ? SpatialReference.create((int)internalGeom.srid()) : MosaicGeometryESRI$.MODULE$.defaultSpatialReference();
        OGCMultiLineString ogcMultiLineString = new OGCMultiLineString(polygon, spatialReference);
        return this.apply((OGCGeometry)ogcMultiLineString);
    }

    /*
     * WARNING - void declaration
     */
    public Polyline createPolyline(InternalCoord[][] shellCollection, boolean dontClose) {
        void var3_3;
        Polyline polyline = new Polyline();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])shellCollection)).foreach((Function1 & Serializable & scala.Serializable)shell -> {
            MosaicMultiLineStringESRI$.addPath$1(polyline, shell, dontClose);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public boolean createPolyline$default$2() {
        return false;
    }

    public MosaicMultiLineStringESRI apply(OGCGeometry geometry) {
        return new MosaicMultiLineStringESRI((OGCMultiLineString)geometry);
    }

    @Override
    public <T extends MosaicGeometry> MosaicMultiLineStringESRI fromSeq(Seq<T> geomSeq, Enumeration.Value geomType) {
        SpatialReference spatialReference = SpatialReference.create((int)((MosaicGeometry)geomSeq.head()).getSpatialReference());
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(((MosaicGeometry)geomSeq.head()).getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.LINESTRING();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            if (value != null) {
                Enumeration.Value value4 = value;
                throw new UnsupportedOperationException(new StringBuilder(57).append("MosaicGeometry.fromSeq() cannot create ").append(geomType.toString()).append(" from ").append(value4.toString()).append(" geometries.").toString());
            }
            throw new MatchError((Object)value);
        }
        Seq extractedLines = (Seq)geomSeq.map((Function1 & Serializable & scala.Serializable)x$2 -> (MosaicLineStringESRI)x$2, Seq$.MODULE$.canBuildFrom());
        Polyline polyline = new Polyline();
        extractedLines.foreach((Function1 & Serializable & scala.Serializable)l -> {
            polyline.add((MultiPath)((Polyline)l.getGeom().getEsriGeometry()), true);
            return BoxedUnit.UNIT;
        });
        OGCMultiLineString oGCMultiLineString = new OGCMultiLineString(polyline, spatialReference);
        OGCMultiLineString newGeom = oGCMultiLineString;
        return this.apply((OGCGeometry)newGeom);
    }

    public <T extends MosaicGeometry> Enumeration.Value fromSeq$default$2() {
        return GeometryTypeEnum$.MODULE$.MULTILINESTRING();
    }

    @Override
    public MosaicGeometry fromWKB(byte[] wkb) {
        return MosaicGeometryESRI$.MODULE$.fromWKB(wkb);
    }

    @Override
    public MosaicGeometry fromWKT(String wkt) {
        return MosaicGeometryESRI$.MODULE$.fromWKT(wkt);
    }

    @Override
    public MosaicGeometry fromJSON(String geoJson) {
        return MosaicGeometryESRI$.MODULE$.fromJSON(geoJson);
    }

    @Override
    public MosaicGeometry fromHEX(String hex) {
        return MosaicGeometryESRI$.MODULE$.fromHEX(hex);
    }

    @Override
    public MosaicGeometry fromKryo(InternalRow row) {
        return MosaicGeometryESRI$.MODULE$.fromKryo(row);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final void addPath$1(Polyline polyline, InternalCoord[] path, boolean dontClose$1) {
        block0: {
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path)).nonEmpty()) break block0;
            InternalCoord start = (InternalCoord)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path)).head();
            InternalCoord end = (InternalCoord)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path)).last();
            InternalCoord[] tail = dontClose$1 && start.equals(end) ? (InternalCoord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path)).tail())).dropRight(1) : (InternalCoord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path)).tail();
            polyline.startPath(BoxesRunTime.unboxToDouble((Object)start.coords().apply(0)), BoxesRunTime.unboxToDouble((Object)start.coords().apply(1)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tail)).foreach((Function1 & Serializable & scala.Serializable)point -> {
                polyline.lineTo(BoxesRunTime.unboxToDouble((Object)point.coords().apply(0)), BoxesRunTime.unboxToDouble((Object)point.coords().apply(1)));
                return BoxedUnit.UNIT;
            });
        }
    }

    private MosaicMultiLineStringESRI$() {
        MODULE$ = this;
        GeometryReader.$init$(this);
    }
}

