/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineString;
import com.databricks.labs.mosaic.core.geometry.multilinestring.MosaicMultiLineString;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.MosaicChip;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class Mosaic$ {
    public static Mosaic$ MODULE$;

    static {
        new Mosaic$();
    }

    public Seq<MosaicChip> mosaicFill(MosaicGeometry geometry, int resolution, boolean keepCoreGeom, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        double radius = indexSystem.getBufferRadius(geometry, resolution, geometryAPI);
        MosaicGeometry carvedGeometry = geometry.buffer(-radius);
        MosaicGeometry borderGeometry = carvedGeometry.isEmpty() ? geometry.buffer(radius * 1.01).simplify(0.01 * radius) : geometry.boundary().buffer(radius * 1.01).simplify(0.01 * radius);
        Seq<Object> coreIndices = indexSystem.polyfill(carvedGeometry, resolution, (Option<GeometryAPI>)new Some((Object)geometryAPI));
        Seq<Object> borderIndices = indexSystem.polyfill(borderGeometry, resolution, (Option<GeometryAPI>)new Some((Object)geometryAPI));
        Seq<MosaicChip> coreChips = indexSystem.getCoreChips(coreIndices, keepCoreGeom, geometryAPI);
        Seq<MosaicChip> borderChips = indexSystem.getBorderChips(geometry, borderIndices, keepCoreGeom, geometryAPI);
        return (Seq)coreChips.$plus$plus(borderChips, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<MosaicChip> lineFill(MosaicGeometry geometry, int resolution, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        Seq seq;
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(geometry.getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.LINESTRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            seq = this.lineDecompose((MosaicLineString)geometry, resolution, indexSystem, geometryAPI);
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.MULTILINESTRING();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                MosaicMultiLineString multiLine = (MosaicMultiLineString)geometry;
                seq = (Seq)multiLine.flatten().flatMap((Function1 & Serializable & scala.Serializable)line -> MODULE$.lineDecompose((MosaicLineString)line, resolution, indexSystem, geometryAPI), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)value);
            }
        }
        return seq;
    }

    private Seq<MosaicChip> lineDecompose(MosaicLineString line, int resolution, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        MosaicPoint start = (MosaicPoint)((MosaicLineString)line.getShells().head()).asSeq().head();
        long startIndex = indexSystem.pointToIndex(start.getX(), start.getY(), resolution);
        Seq result = this.traverseLine$1(line, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{startIndex})), Predef$.MODULE$.Set().empty(), (Seq)Seq$.MODULE$.empty(), indexSystem, geometryAPI);
        return result;
    }

    public static final /* synthetic */ Tuple2 $anonfun$lineDecompose$1(IndexSystem indexSystem$2, GeometryAPI geometryAPI$2, MosaicLineString line$1, Set newTraversed$1, Tuple2 accumulator, long current) {
        Tuple2 tuple2;
        MosaicGeometry indexGeom = indexSystem$2.indexToGeometry(current, geometryAPI$2);
        MosaicGeometry lineSegment = line$1.intersection(indexGeom);
        if (!lineSegment.isEmpty()) {
            MosaicChip chip = new MosaicChip(false, current, lineSegment);
            Seq<Object> kRing = indexSystem$2.kRing(current, 1);
            Seq toQueue = (Seq)kRing.filterNot((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)elem -> newTraversed$1.contains((Object)BoxesRunTime.boxToLong((long)elem)));
            tuple2 = new Tuple2((Object)toQueue, ((TraversableLike)accumulator._2()).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MosaicChip[]{chip})), Seq$.MODULE$.canBuildFrom()));
        } else {
            tuple2 = accumulator;
        }
        return tuple2;
    }

    private final Seq traverseLine$1(MosaicLineString line, Seq queue, Set traversed, Seq chips, IndexSystem indexSystem$2, GeometryAPI geometryAPI$2) {
        Seq newChips;
        while (true) {
            Set newTraversed = (Set)traversed.$plus$plus((GenTraversableOnce)queue);
            Tuple2 tuple2 = (Tuple2)queue.foldLeft((Object)new Tuple2((Object)Seq$.MODULE$.empty(), (Object)chips), (Function2 & Serializable & scala.Serializable)(accumulator, current) -> Mosaic$.$anonfun$lineDecompose$1(indexSystem$2, geometryAPI$2, line, newTraversed, accumulator, BoxesRunTime.unboxToLong((Object)current)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq newQueue = (Seq)tuple2._1();
            Seq newChips2 = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newQueue, (Object)newChips2);
            Tuple2 tuple23 = tuple22;
            Seq newQueue2 = (Seq)tuple23._1();
            newChips = (Seq)tuple23._2();
            if (newQueue2.isEmpty()) break;
            chips = newChips;
            traversed = newTraversed;
            queue = newQueue2;
        }
        return newChips;
    }

    private Mosaic$() {
        MODULE$ = this;
    }
}

