/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.index;

import com.databricks.labs.mosaic.core.Mosaic$;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI$;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.index.IndexSystemID$;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.MosaicChip;
import com.databricks.labs.mosaic.core.types.package$;
import com.databricks.labs.mosaic.expressions.index.IndexGeometry;
import com.databricks.labs.mosaic.expressions.index.MosaicExplode;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class MosaicExplode$
implements scala.Serializable {
    public static MosaicExplode$ MODULE$;

    static {
        new MosaicExplode$();
    }

    public TraversableOnce<InternalRow> evalImpl(InternalRow input, Expression child, String indexSystemName, String geometryAPIName) {
        Seq<MosaicChip> seq;
        InternalRow inputData = (InternalRow)child.eval(input);
        DataType geomType = ((StructField)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])((StructType)child.dataType()).fields())).head()).dataType();
        IndexSystem indexSystem = IndexSystemID$.MODULE$.getIndexSystem(IndexSystemID$.MODULE$.apply(indexSystemName));
        GeometryAPI geometryAPI = GeometryAPI$.MODULE$.apply(geometryAPIName);
        MosaicGeometry geometry = geometryAPI.geometry(inputData, geomType);
        int resolution = indexSystem.getResolution(BoxesRunTime.boxToInteger(inputData.getInt(1)));
        boolean keepCoreGeom = inputData.getBoolean(2);
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(geometry.getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.LINESTRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            seq = Mosaic$.MODULE$.lineFill(geometry, resolution, indexSystem, geometryAPI);
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.MULTILINESTRING();
            Enumeration.Value value5 = value;
            seq = !(value4 != null ? !((Object)value4).equals(value5) : value5 != null) ? Mosaic$.MODULE$.lineFill(geometry, resolution, indexSystem, geometryAPI) : Mosaic$.MODULE$.mosaicFill(geometry, resolution, keepCoreGeom, indexSystem, geometryAPI);
        }
        Seq<MosaicChip> chips = seq;
        return chips.map((Function1<MosaicChip, InternalRow> & Serializable & scala.Serializable)row -> InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{row.serialize()}))), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TypeCheckResult checkInputDataTypesImpl(Expression child) {
        StructField[] fields = ((StructType)child.dataType()).fields();
        StructField geomType = (StructField)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])fields)).head();
        StructField resolutionType = fields[1];
        StructField keepCoreGeom = fields[2];
        Tuple3<DataType, DataType, DataType> tuple3 = new Tuple3<DataType, DataType, DataType>(geomType.dataType(), resolutionType.dataType(), keepCoreGeom.dataType());
        if (tuple3 != null) {
            DataType dataType = tuple3._1();
            DataType dataType2 = tuple3._2();
            DataType dataType3 = tuple3._3();
            if (BinaryType$.MODULE$.equals(dataType) && IntegerType$.MODULE$.equals(dataType2) && BooleanType$.MODULE$.equals(dataType3)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple3 != null) {
            DataType dataType = tuple3._1();
            DataType dataType4 = tuple3._2();
            DataType dataType5 = tuple3._3();
            if (StringType$.MODULE$.equals(dataType) && IntegerType$.MODULE$.equals(dataType4) && BooleanType$.MODULE$.equals(dataType5)) {
                return TypeCheckResult.TypeCheckSuccess$.MODULE$;
            }
        }
        if (tuple3 != null) {
            DataType dataType = tuple3._1();
            DataType dataType6 = tuple3._2();
            DataType dataType7 = tuple3._3();
            DataType dataType8 = package$.MODULE$.HexType();
            DataType dataType9 = dataType;
            if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                if (IntegerType$.MODULE$.equals(dataType6) && BooleanType$.MODULE$.equals(dataType7)) {
                    return TypeCheckResult.TypeCheckSuccess$.MODULE$;
                }
            }
        }
        if (tuple3 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(142).append("Input to mosaic explode should be (geometry, resolution, keepCoreGeom) pair. ").append("Geometry type can be WKB, WKT, Hex or Coords. Provided type was: ").append(child.dataType().catalogString()).toString());
        DataType dataType = tuple3._1();
        DataType dataType10 = tuple3._2();
        DataType dataType11 = tuple3._3();
        DataType dataType12 = package$.MODULE$.InternalGeometryType();
        DataType dataType13 = dataType;
        if (dataType12 == null) {
            if (dataType13 != null) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(142).append("Input to mosaic explode should be (geometry, resolution, keepCoreGeom) pair. ").append("Geometry type can be WKB, WKT, Hex or Coords. Provided type was: ").append(child.dataType().catalogString()).toString());
            }
        } else if (!dataType12.equals(dataType13)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(142).append("Input to mosaic explode should be (geometry, resolution, keepCoreGeom) pair. ").append("Geometry type can be WKB, WKT, Hex or Coords. Provided type was: ").append(child.dataType().catalogString()).toString());
        if (!IntegerType$.MODULE$.equals(dataType10)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(142).append("Input to mosaic explode should be (geometry, resolution, keepCoreGeom) pair. ").append("Geometry type can be WKB, WKT, Hex or Coords. Provided type was: ").append(child.dataType().catalogString()).toString());
        if (!BooleanType$.MODULE$.equals(dataType11)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(142).append("Input to mosaic explode should be (geometry, resolution, keepCoreGeom) pair. ").append("Geometry type can be WKB, WKT, Hex or Coords. Provided type was: ").append(child.dataType().catalogString()).toString());
        return TypeCheckResult.TypeCheckSuccess$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StructType elementSchemaImpl(Expression child) {
        StructField[] fields = ((StructType)child.dataType()).fields();
        StructField geomType = (StructField)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])fields)).head();
        StructField resolutionType = fields[1];
        StructField keepCoreGeom = fields[2];
        Tuple3<DataType, DataType, DataType> tuple3 = new Tuple3<DataType, DataType, DataType>(geomType.dataType(), resolutionType.dataType(), keepCoreGeom.dataType());
        if (tuple3 != null) {
            DataType dataType = tuple3._1();
            DataType dataType2 = tuple3._2();
            DataType dataType3 = tuple3._3();
            if (BinaryType$.MODULE$.equals(dataType) && IntegerType$.MODULE$.equals(dataType2) && BooleanType$.MODULE$.equals(dataType3)) {
                return new StructType((StructField[])((Object[])new StructField[]{new StructField("index", package$.MODULE$.ChipType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            }
        }
        if (tuple3 != null) {
            DataType dataType = tuple3._1();
            DataType dataType4 = tuple3._2();
            DataType dataType5 = tuple3._3();
            if (StringType$.MODULE$.equals(dataType) && IntegerType$.MODULE$.equals(dataType4) && BooleanType$.MODULE$.equals(dataType5)) {
                return new StructType((StructField[])((Object[])new StructField[]{new StructField("index", package$.MODULE$.ChipType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            }
        }
        if (tuple3 != null) {
            DataType dataType = tuple3._1();
            DataType dataType6 = tuple3._2();
            DataType dataType7 = tuple3._3();
            DataType dataType8 = package$.MODULE$.HexType();
            DataType dataType9 = dataType;
            if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                if (IntegerType$.MODULE$.equals(dataType6) && BooleanType$.MODULE$.equals(dataType7)) {
                    return new StructType((StructField[])((Object[])new StructField[]{new StructField("index", package$.MODULE$.ChipType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
                }
            }
        }
        if (tuple3 == null) throw new Error(new StringBuilder(142).append("Input to mosaic explode should be (geometry, resolution, keepCoreGeom) pair. ").append("Geometry type can be WKB, WKT, Hex or Coords. Provided type was: ").append(child.dataType().catalogString()).toString());
        DataType dataType = tuple3._1();
        DataType dataType10 = tuple3._2();
        DataType dataType11 = tuple3._3();
        DataType dataType12 = package$.MODULE$.InternalGeometryType();
        DataType dataType13 = dataType;
        if (dataType12 == null) {
            if (dataType13 != null) {
                throw new Error(new StringBuilder(142).append("Input to mosaic explode should be (geometry, resolution, keepCoreGeom) pair. ").append("Geometry type can be WKB, WKT, Hex or Coords. Provided type was: ").append(child.dataType().catalogString()).toString());
            }
        } else if (!dataType12.equals(dataType13)) throw new Error(new StringBuilder(142).append("Input to mosaic explode should be (geometry, resolution, keepCoreGeom) pair. ").append("Geometry type can be WKB, WKT, Hex or Coords. Provided type was: ").append(child.dataType().catalogString()).toString());
        if (!IntegerType$.MODULE$.equals(dataType10)) throw new Error(new StringBuilder(142).append("Input to mosaic explode should be (geometry, resolution, keepCoreGeom) pair. ").append("Geometry type can be WKB, WKT, Hex or Coords. Provided type was: ").append(child.dataType().catalogString()).toString());
        if (!BooleanType$.MODULE$.equals(dataType11)) throw new Error(new StringBuilder(142).append("Input to mosaic explode should be (geometry, resolution, keepCoreGeom) pair. ").append("Geometry type can be WKB, WKT, Hex or Coords. Provided type was: ").append(child.dataType().catalogString()).toString());
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("index", package$.MODULE$.ChipType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
    }

    public Expression makeCopyImpl(Object[] newArgs, Expression instance, String indexSystemName, String geometryAPIName) {
        Expression arg1 = (Expression)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps(newArgs)).head();
        MosaicExplode res = new MosaicExplode(arg1, indexSystemName, geometryAPIName);
        res.copyTagsFrom((TreeNode)instance);
        return res;
    }

    public ExpressionInfo registryExpressionInfo(Option<String> db) {
        return new ExpressionInfo(IndexGeometry.class.getCanonicalName(), (String)db.orNull(Predef$.MODULE$.$conforms()), "mosaic_explode", new StringOps(Predef$.MODULE$.augmentString("\n            |    _FUNC_(struct(geometry, resolution, keepCoreGeom)) - Generates the mosaic chips for the input\n            |    geometry at a given resolution. Geometry and resolution are provided via struct wrapper to ensure\n            |    UnaryExpression API is respected.\n            ")).stripMargin(), "", new StringOps(Predef$.MODULE$.augmentString("\n            |    Examples:\n            |      > SELECT _FUNC_(a, b, c);\n            |        {index_id, is_border, chip_geom}\n            |        {index_id, is_border, chip_geom}\n            |        ...\n            |        {index_id, is_border, chip_geom}\n            |  ")).stripMargin(), "", "generator_funcs", "1.0", "", "built-in");
    }

    public MosaicExplode apply(Expression pair, String indexSystemName, String geometryAPIName) {
        return new MosaicExplode(pair, indexSystemName, geometryAPIName);
    }

    public Option<Tuple3<Expression, String, String>> unapply(MosaicExplode x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Expression, String, String>>(new Tuple3<Expression, String, String>(x$0.pair(), x$0.indexSystemName(), x$0.geometryAPIName()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MosaicExplode$() {
        MODULE$ = this;
    }
}

